/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.chromite;

import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.chromite.App;
import org.luwrain.controls.CachedTreeModel;
import org.luwrain.controls.CachedTreeModelSource;
import org.luwrain.controls.SimpleArea;
import org.luwrain.controls.TreeArea;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.events.InputEvent;
import org.luwrain.web.chromite.Element;
import org.luwrain.web.chromite.Elements;

final class MainLayout
extends LayoutBase
implements TreeArea.ClickHandler {
    private final App app;
    final TreeArea treeArea;
    final SimpleArea attrArea;
    private Elements elements = null;

    MainLayout(App app) {
        super((AppBase)app);
        this.app = app;
        this.treeArea = new TreeArea(this.treeParams(params -> {
            params.name = "\u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430";
            params.model = new CachedTreeModel((CachedTreeModelSource)new Model());
            params.clickHandler = this;
        }));
        this.attrArea = new SimpleArea(this.getControlContext(), "\u0410\u0442\u0440\u0438\u0431\u0443\u0442\u044b");
        this.setAreaLayout(AreaLayout.LEFT_RIGHT, (Area)this.treeArea, this.actions(new LayoutBase.ActionInfo[]{this.action("test", "\u041e\u0442\u043a\u0440\u044b\u0442\u044c", new InputEvent(InputEvent.Special.F6), this::actOpen), this.action("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c", new InputEvent(InputEvent.Special.F5), this::actRefresh)}), (Area)this.attrArea, this.actions(new LayoutBase.ActionInfo[0]));
    }

    public boolean onTreeClick(TreeArea treeArea, Object obj) {
        if (obj instanceof Element) {
            Element el = (Element)obj;
            this.attrArea.update(lines -> {
                lines.clear();
                lines.addLine("X: " + String.valueOf(el.getX()));
                lines.addLine("Y: " + String.valueOf(el.getY()));
                lines.addLine("Width: " + String.valueOf(el.getWidth()));
                lines.addLine("Height: " + String.valueOf(el.getHeight()));
                lines.addLine("");
            });
            this.setActiveArea((Area)this.attrArea);
            return true;
        }
        return false;
    }

    private boolean actOpen() {
        String url = this.app.getConv().openUrl("https://");
        if (url == null || url.trim().isEmpty()) {
            return true;
        }
        this.app.getChromite().navigate(url.trim());
        return true;
    }

    private boolean actRefresh() {
        this.elements = this.app.getChromite().getPage();
        this.treeArea.refresh();
        return true;
    }

    private final class Model
    implements CachedTreeModelSource {
        private Model() {
        }

        public Object getRoot() {
            if (MainLayout.this.elements == null) {
                return "\u041d\u0435\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0433\u043e";
            }
            return MainLayout.this.elements;
        }

        public Object[] getChildObjs(Object obj) {
            if (obj instanceof Elements) {
                return ((Elements)obj).getChildren();
            }
            if (obj instanceof Element) {
                return ((Element)obj).getChildren();
            }
            return new Object[0];
        }
    }
}

