/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.webinspector;

import com.sun.javafx.webkit.WebConsoleListener;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.webinspector.Conv;
import org.luwrain.app.webinspector.MainLayout;
import org.luwrain.app.webinspector.Strings;
import org.luwrain.app.webinspector.WebTree;
import org.luwrain.app.webinspector.WebTreeLayout;
import org.luwrain.core.Application;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.Sounds;
import org.luwrain.graphical.FxThread;
import org.luwrain.web.WebKitBlock;
import org.luwrain.web.WebKitBlocks;

public final class App
extends AppBase<Strings>
implements Application {
    static final String LOG_COMPONENT = "webins";
    static App instance = null;
    final List<String> messages = new ArrayList<String>();
    private MainLayout mainLayout = null;
    private WebTreeLayout treeLayout = null;
    private Conv conv = null;
    private WebEngine webEngine = null;
    private WebView webView = null;
    private Runnable firstSwitching = null;
    final List<WebKitBlock> blocks = new ArrayList<WebKitBlock>();
    private WebTree tree = null;

    public App() {
        super(Strings.class, "luwrain.webinspector");
        instance = this;
    }

    public AreaLayout onAppInit() {
        this.conv = new Conv(this);
        FxThread.runSync(() -> {
            this.webView = new WebView();
            this.webEngine = this.webView.getEngine();
            this.webEngine.setUserDataDirectory(this.getLuwrain().getAppDataDir("luwrain.webins").toFile());
            this.webEngine.getLoadWorker().stateProperty().addListener((ov, oldState, newState) -> this.onStateChanged((ObservableValue<? extends Worker.State>)ov, (Worker.State)oldState, (Worker.State)newState));
            this.webEngine.setOnError(event -> this.print("ERROR: " + event.getMessage()));
            this.webEngine.getLoadWorker().progressProperty().addListener((ov, o, n) -> this.print("Progress " + String.valueOf(n)));
            this.webEngine.setOnAlert(event -> this.print("ALERT: " + (String)event.getData()));
            WebConsoleListener.setDefaultListener((view, message, lineNum, source) -> {
                this.print("Console message");
                this.print(message);
            });
            this.webView.setVisible(false);
        });
        this.mainLayout = new MainLayout(this);
        this.treeLayout = new WebTreeLayout(this);
        this.setAppName(((Strings)this.getStrings()).appName());
        this.getLuwrain().showGraphical(graphicalModeControl -> {
            this.getWebView().setOnKeyReleased(event -> {
                switch (event.getCode()) {
                    case ESCAPE: {
                        this.getLuwrain().runUiSafely(() -> this.getLuwrain().playSound(Sounds.OK));
                        graphicalModeControl.close();
                    }
                }
            });
            this.firstSwitching = () -> graphicalModeControl.close();
            this.getWebView().setVisible(true);
            this.getEngine().load("https://luwrain.org");
            return this.getWebView();
        });
        return this.mainLayout.getAreaLayout();
    }

    public boolean onEscape() {
        this.closeApp();
        return true;
    }

    void update() {
        FxThread.runSync(() -> {
            WebKitBlocks b = new WebKitBlocks(this.webEngine);
            b.process(100);
            this.blocks.clear();
            this.blocks.addAll(b.blocks);
        });
        this.mainLayout.blocksArea.refresh();
    }

    private void onStateChanged(ObservableValue<? extends Worker.State> ov, Worker.State oldState, Worker.State newState) {
        if (newState == null) {
            return;
        }
        this.print("New state: " + newState.toString());
        switch (newState) {
            case SUCCEEDED: {
                WebKitBlocks b = new WebKitBlocks(this.webEngine);
                b.process(100);
                this.blocks.clear();
                this.blocks.addAll(b.blocks);
                this.getLuwrain().runUiSafely(() -> {
                    this.mainLayout.blocksArea.refresh();
                    this.getLuwrain().playSound(Sounds.MESSAGE);
                });
                this.print("The page is loaded");
                if (this.firstSwitching == null) break;
                this.firstSwitching.run();
                this.firstSwitching = null;
                break;
            }
            case FAILED: {
                this.getLuwrain().runUiSafely(() -> this.getLuwrain().playSound(Sounds.ERROR));
            }
        }
    }

    void print(String message) {
        this.messages.add(0, message);
        if (this.mainLayout != null) {
            this.getLuwrain().runUiSafely(() -> this.mainLayout.consoleArea.refresh());
        }
    }

    Conv getConv() {
        return this.conv;
    }

    WebView getWebView() {
        return this.webView;
    }

    WebEngine getEngine() {
        return this.webEngine;
    }

    WebTree getTree() {
        return this.tree;
    }

    public static void log(String msg) {
        if (instance != null) {
            instance.print(msg);
        }
    }
}

