/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.webinspector;

import java.util.Set;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.webinspector.App;
import org.luwrain.app.webinspector.Strings;
import org.luwrain.controls.ConsoleArea;
import org.luwrain.controls.ConsoleUtils;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.controls.SimpleArea;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Hint;
import org.luwrain.core.Luwrain;
import org.luwrain.core.Sounds;
import org.luwrain.core.Suggestions;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.graphical.FxThread;
import org.luwrain.web.WebKitBlock;
import org.luwrain.web.WebKitBlockBase;

final class MainLayout
extends LayoutBase
implements ConsoleArea.InputHandler {
    private final App app;
    final ConsoleArea<String> consoleArea;
    final ListArea<WebKitBlock> blocksArea;
    final SimpleArea stylesArea;

    MainLayout(final App app) {
        super((AppBase)app);
        this.app = app;
        this.consoleArea = new ConsoleArea(this.consoleParams(params -> {
            params.name = ((Strings)app.getStrings()).appName();
            params.model = new ConsoleUtils.ListModel(app.messages);
            params.appearance = new ConsoleAppearance();
            params.inputHandler = this;
            params.inputPrefix = "WebKit>";
        }));
        this.blocksArea = new ListArea<WebKitBlock>(this.listParams(params -> {
            params.name = "\u0411\u043b\u043e\u043a\u0438";
            params.model = new ListUtils.ListModel(app.blocks);
            params.appearance = new BlocksAppearance();
            params.clickHandler = this::onBlocksClick;
        })){

            public boolean onSystemEvent(SystemEvent event) {
                if (event.getType() == SystemEvent.Type.REGULAR) {
                    switch (event.getCode()) {
                        case REFRESH: {
                            app.update();
                            app.getLuwrain().playSound(Sounds.OK);
                            return true;
                        }
                        case OK: {
                            return MainLayout.this.onShowStyles();
                        }
                    }
                }
                return super.onSystemEvent(event);
            }
        };
        this.stylesArea = new SimpleArea(this.getControlContext(), "Styles"){

            public void announceLine(int index, String line) {
                if (line.trim().isEmpty()) {
                    app.setEventResponse(DefaultEventResponse.hint((Hint)Hint.EMPTY_LINE));
                    return;
                }
                app.setEventResponse(DefaultEventResponse.text((String)MainLayout.this.getLuwrain().getSpeakableText(line, Luwrain.SpeakableTextType.PROGRAMMING)));
            }
        };
        this.setAreaLayout(AreaLayout.LEFT_TOP_BOTTOM, (Area)this.consoleArea, this.actions(new LayoutBase.ActionInfo[]{this.action("show-graphical", ((Strings)app.getStrings()).actionShowGraphical(), new InputEvent(InputEvent.Special.F10), this::actShowGraphical)}), (Area)this.blocksArea, null, (Area)this.stylesArea, null);
    }

    public ConsoleArea.InputHandler.Result onConsoleInput(ConsoleArea area, String text) {
        if (text.trim().isEmpty()) {
            return ConsoleArea.InputHandler.Result.REJECTED;
        }
        if (text.trim().equals("test")) {
            return this.onTest() ? ConsoleArea.InputHandler.Result.CLEAR_INPUT : ConsoleArea.InputHandler.Result.REJECTED;
        }
        FxThread.runSync(() -> this.app.getEngine().load(text));
        return ConsoleArea.InputHandler.Result.CLEAR_INPUT;
    }

    private boolean onTest() {
        this.app.getLuwrain().showGraphical(graphicalModeControl -> {
            this.app.getWebView().setOnKeyReleased(event -> {
                switch (event.getCode()) {
                    case ESCAPE: {
                        this.app.getLuwrain().runUiSafely(() -> this.app.getLuwrain().playSound(Sounds.OK));
                        graphicalModeControl.close();
                    }
                }
            });
            this.app.getWebView().setVisible(true);
            this.app.getEngine().load("https://marigostra.ru");
            return this.app.getWebView();
        });
        return true;
    }

    private boolean onBlocksClick(ListArea<WebKitBlock> area, int index, WebKitBlock block) {
        this.stylesArea.update(lines -> {
            lines.clear();
            lines.addLine("");
            lines.addLine("\u041a\u043b\u0430\u0441\u0441: " + block.className);
            lines.addLine("\u0422\u0435\u0433: " + block.tagName);
            lines.addLine("\u0422\u0435\u043a\u0441\u0442\u043e\u0432\u044b\u0435 \u0440\u0430\u0437\u043c\u0435\u0440\u044b: " + block.getLeft() + ", " + block.getRight() + ", " + block.getTop() + ", " + block.getBottom());
            lines.addLine("\u0418\u0441\u0445\u043e\u0434\u043d\u044b\u0435 \u0440\u0430\u0437\u043c\u0435\u0440\u044b: " + block.srcLeft + ", " + block.srcRight + ", " + block.srcTop + ", " + block.srcBottom);
            lines.addLine("\u0412\u0438\u0434\u0438\u043c\u044b\u0439: " + (block.visible ? "\u0434\u0430" : "\u043d\u0435\u0442"));
            lines.addLine("");
            lines.addLine(block.runs.size() + " runs, " + block.lines.size() + " lines");
            lines.addLine("Runs:");
            for (WebKitBlockBase.Run r : block.runs) {
                lines.addLine(r.toString().replaceAll("\u00a0", " "));
            }
            lines.addLine("");
            lines.addLine("\u0421\u0442\u0440\u043e\u043a\u0438:");
            for (WebKitBlockBase.Line l : block.lines) {
                StringBuilder b = new StringBuilder();
                for (WebKitBlockBase.Fragment f : l.fragments) {
                    b.append("'").append(f.text()).append("',");
                }
                String s = new String(b);
                if (s.isEmpty()) continue;
                lines.addLine(s.substring(0, s.length() - 1).replaceAll("\u00a0", " "));
            }
            lines.addLine("");
            lines.addLine("\u0421\u0442\u0438\u043b\u044c:");
            String style = block.getStyle();
            if (style != null) {
                for (String l : style.split(";", -1)) {
                    lines.addLine(l);
                }
            }
        });
        this.stylesArea.setHotPoint(0, 0);
        this.setActiveArea((Area)this.stylesArea);
        return true;
    }

    private boolean actShowGraphical() {
        this.app.getLuwrain().showGraphical(graphicalModeControl -> {
            this.app.getWebView().setOnKeyReleased(event -> {
                switch (event.getCode()) {
                    case ESCAPE: {
                        this.app.getLuwrain().runUiSafely(() -> this.app.getLuwrain().playSound(Sounds.OK));
                        graphicalModeControl.close();
                    }
                }
            });
            this.app.getWebView().setVisible(true);
            return this.app.getWebView();
        });
        return true;
    }

    private boolean onShowStyles() {
        this.stylesArea.update(lines -> {
            lines.clear();
            lines.addLine("Test styles box");
        });
        return true;
    }

    private final class BlocksAppearance
    extends ListUtils.AbstractAppearance<WebKitBlock> {
        private BlocksAppearance() {
        }

        public void announceItem(WebKitBlock block, Set<ListArea.Appearance.Flags> flags) {
            MainLayout.this.getLuwrain().setEventResponse(DefaultEventResponse.listItem((Sounds)Sounds.LIST_ITEM, (String)block.text, (Suggestions)Suggestions.LIST_ITEM));
        }

        public String getScreenAppearance(WebKitBlock block, Set<ListArea.Appearance.Flags> flags) {
            return block.text;
        }
    }

    private final class ConsoleAppearance
    implements ConsoleArea.Appearance<String> {
        private ConsoleAppearance() {
        }

        public void announceItem(String text) {
            MainLayout.this.getLuwrain().setEventResponse(DefaultEventResponse.listItem((String)text));
        }

        public String getTextAppearance(String text) {
            return text;
        }
    }
}

