/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.web;

import com.sun.webkit.dom.CommentImpl;
import com.sun.webkit.dom.DOMWindowImpl;
import com.sun.webkit.dom.ElementImpl;
import com.sun.webkit.dom.HTMLAnchorElementImpl;
import com.sun.webkit.dom.HTMLBRElementImpl;
import com.sun.webkit.dom.HTMLButtonElementImpl;
import com.sun.webkit.dom.HTMLDivElementImpl;
import com.sun.webkit.dom.HTMLElementImpl;
import com.sun.webkit.dom.HTMLLIElementImpl;
import com.sun.webkit.dom.HTMLUListElementImpl;
import com.sun.webkit.dom.NodeImpl;
import com.sun.webkit.dom.TextImpl;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.web.WebEngine;
import org.luwrain.app.webinspector.App;
import org.luwrain.core.Log;
import org.luwrain.graphical.FxThread;
import org.luwrain.web.BlocksCollector;
import org.luwrain.web.WebKitBlock;
import org.luwrain.web.WebKitBlockBase;
import org.luwrain.web.WebKitGeom;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLBodyElement;
import org.w3c.dom.html.HTMLDocument;
import org.w3c.dom.views.DocumentView;

public final class WebKitBlocksCollector
extends BlocksCollector<Node, WebKitBlock> {
    public final WebEngine engine;
    public final HTMLDocument doc;
    public final DOMWindowImpl window;
    public final HTMLBodyElement body;
    final WebKitGeom geom;

    public WebKitBlocksCollector(WebEngine engine) {
        FxThread.ensure();
        this.engine = engine;
        this.doc = (HTMLDocument)engine.documentProperty().getValue();
        this.window = (DOMWindowImpl)((DocumentView)((Object)this.doc)).getDefaultView();
        HTMLBodyElement n = this.body = (HTMLBodyElement)this.doc.getBody();
        this.geom = new WebKitGeom(engine);
        Log.debug((String)"proba", (String)"new");
    }

    @Override
    public List<Node> getChildNodes(Node node) {
        ArrayList<Node> res = new ArrayList<Node>();
        NodeList items = node.getChildNodes();
        if (items != null) {
            for (int i = 0; i < items.getLength(); ++i) {
                res.add(items.item(i));
            }
        }
        return res;
    }

    @Override
    public boolean isMarkupNode(Node node) {
        if (node instanceof HTMLAnchorElementImpl) {
            return true;
        }
        if (node instanceof CommentImpl) {
            return false;
        }
        if (node instanceof HTMLLIElementImpl) {
            return false;
        }
        if (node instanceof HTMLUListElementImpl) {
            return false;
        }
        if (node instanceof HTMLButtonElementImpl) {
            return false;
        }
        if (node instanceof HTMLDivElementImpl) {
            return false;
        }
        if (node instanceof HTMLBRElementImpl) {
            return false;
        }
        if (node instanceof HTMLElementImpl) {
            HTMLElementImpl el = (HTMLElementImpl)node;
            switch (el.getTagName()) {
                case "BR": 
                case "EM": 
                case "B": 
                case "SPAN": 
                case "STRONG": 
                case "IMG": {
                    return true;
                }
            }
            switch (el.getTagName()) {
                case "BODY": 
                case "LINK": 
                case "STYLE": 
                case "P": 
                case "HR": 
                case "INPUT": 
                case "SCRIPT": 
                case "NOSCRIPT": 
                case "TEXTAREA": 
                case "H1": 
                case "H2": 
                case "H3": {
                    return false;
                }
            }
            App.log("Unmatched element " + el.getTagName());
            return false;
        }
        if (!(node instanceof ElementImpl)) {
            App.log("Unclassified: " + node.getClass().getSimpleName());
        }
        return false;
    }

    @Override
    public boolean isTextNode(Node node) {
        return node instanceof TextImpl;
    }

    @Override
    public void addTextToBlock(Node node, WebKitBlock block) {
        TextImpl t = (TextImpl)node;
        block.runs.add(new WebKitBlockBase.Run(t.getWholeText()));
    }

    @Override
    public WebKitBlock createBlock(Node node) {
        return new WebKitBlock(this.window, this.geom, (NodeImpl)node);
    }

    @Override
    public boolean saveBlock(WebKitBlock block) {
        StringBuilder b = new StringBuilder();
        for (WebKitBlockBase.Run r : block.runs) {
            b.append(r.text);
        }
        block.text = new String(b);
        return !block.text.trim().isEmpty();
    }
}

