/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.objects.store;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.vk.api.sdk.objects.Validable;
import com.vk.api.sdk.objects.annotations.Required;
import com.vk.api.sdk.objects.base.BoolInt;
import com.vk.api.sdk.objects.base.Image;
import com.vk.api.sdk.objects.base.StickerNew;
import com.vk.api.sdk.objects.store.ProductType;
import java.util.List;
import java.util.Objects;

public class Product
implements Validable {
    @SerializedName(value="id")
    @Required
    private Integer id;
    @SerializedName(value="type")
    @Required
    private ProductType type;
    @SerializedName(value="is_new")
    private Boolean isNew;
    @SerializedName(value="purchased")
    private BoolInt purchased;
    @SerializedName(value="active")
    private BoolInt active;
    @SerializedName(value="promoted")
    private BoolInt promoted;
    @SerializedName(value="purchase_date")
    private Integer purchaseDate;
    @SerializedName(value="title")
    private String title;
    @SerializedName(value="stickers")
    private List<StickerNew> stickers;
    @SerializedName(value="style_sticker_ids")
    private List<Integer> styleStickerIds;
    @SerializedName(value="icon")
    private List<Image> icon;
    @SerializedName(value="previews")
    private List<Image> previews;
    @SerializedName(value="has_animation")
    private Boolean hasAnimation;
    @SerializedName(value="subtitle")
    private String subtitle;

    public Integer getId() {
        return this.id;
    }

    public Product setId(Integer id) {
        this.id = id;
        return this;
    }

    public ProductType getType() {
        return this.type;
    }

    public Product setType(ProductType type) {
        this.type = type;
        return this;
    }

    public Boolean getIsNew() {
        return this.isNew;
    }

    public Product setIsNew(Boolean isNew) {
        this.isNew = isNew;
        return this;
    }

    public boolean isPurchased() {
        return this.purchased == BoolInt.YES;
    }

    public BoolInt getPurchased() {
        return this.purchased;
    }

    public boolean isActive() {
        return this.active == BoolInt.YES;
    }

    public BoolInt getActive() {
        return this.active;
    }

    public boolean isPromoted() {
        return this.promoted == BoolInt.YES;
    }

    public BoolInt getPromoted() {
        return this.promoted;
    }

    public Integer getPurchaseDate() {
        return this.purchaseDate;
    }

    public Product setPurchaseDate(Integer purchaseDate) {
        this.purchaseDate = purchaseDate;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public Product setTitle(String title) {
        this.title = title;
        return this;
    }

    public List<StickerNew> getStickers() {
        return this.stickers;
    }

    public Product setStickers(List<StickerNew> stickers) {
        this.stickers = stickers;
        return this;
    }

    public List<Integer> getStyleStickerIds() {
        return this.styleStickerIds;
    }

    public Product setStyleStickerIds(List<Integer> styleStickerIds) {
        this.styleStickerIds = styleStickerIds;
        return this;
    }

    public List<Image> getIcon() {
        return this.icon;
    }

    public Product setIcon(List<Image> icon) {
        this.icon = icon;
        return this;
    }

    public List<Image> getPreviews() {
        return this.previews;
    }

    public Product setPreviews(List<Image> previews) {
        this.previews = previews;
        return this;
    }

    public Boolean getHasAnimation() {
        return this.hasAnimation;
    }

    public Product setHasAnimation(Boolean hasAnimation) {
        this.hasAnimation = hasAnimation;
        return this;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public Product setSubtitle(String subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.purchaseDate, this.hasAnimation, this.icon, this.active, this.isNew, this.type, this.promoted, this.title, this.purchased, this.styleStickerIds, this.subtitle, this.previews, this.stickers, this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Product product = (Product)o;
        return Objects.equals(this.isNew, product.isNew) && Objects.equals(this.icon, product.icon) && Objects.equals(this.active, product.active) && Objects.equals(this.type, product.type) && Objects.equals(this.promoted, product.promoted) && Objects.equals(this.title, product.title) && Objects.equals(this.hasAnimation, product.hasAnimation) && Objects.equals(this.purchased, product.purchased) && Objects.equals(this.styleStickerIds, product.styleStickerIds) && Objects.equals(this.subtitle, product.subtitle) && Objects.equals(this.previews, product.previews) && Objects.equals(this.stickers, product.stickers) && Objects.equals(this.id, product.id) && Objects.equals(this.purchaseDate, product.purchaseDate);
    }

    public String toString() {
        Gson gson = new Gson();
        return gson.toJson((Object)this);
    }

    public String toPrettyString() {
        StringBuilder sb = new StringBuilder("Product{");
        sb.append("isNew=").append(this.isNew);
        sb.append(", icon=").append(this.icon);
        sb.append(", active=").append(this.active);
        sb.append(", type='").append(this.type).append("'");
        sb.append(", promoted=").append(this.promoted);
        sb.append(", title='").append(this.title).append("'");
        sb.append(", hasAnimation=").append(this.hasAnimation);
        sb.append(", purchased=").append(this.purchased);
        sb.append(", styleStickerIds=").append(this.styleStickerIds);
        sb.append(", subtitle='").append(this.subtitle).append("'");
        sb.append(", previews=").append(this.previews);
        sb.append(", stickers=").append(this.stickers);
        sb.append(", id=").append(this.id);
        sb.append(", purchaseDate=").append(this.purchaseDate);
        sb.append('}');
        return sb.toString();
    }
}

