/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.notepad;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.notepad.App;
import org.luwrain.app.notepad.Appearance;
import org.luwrain.app.notepad.Strings;
import org.luwrain.app.notepad.TextFragmentUtils;
import org.luwrain.controls.EditSpellChecking;
import org.luwrain.controls.edit.EditArea;
import org.luwrain.controls.edit.MultilineEdit;
import org.luwrain.controls.edit.MultilineEditModelWrap;
import org.luwrain.core.Area;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.LineMarks;
import org.luwrain.core.Lines;
import org.luwrain.core.Luwrain;
import org.luwrain.core.MutableMarkedLines;
import org.luwrain.core.Sounds;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.core.queries.CurrentDirQuery;
import org.luwrain.nlp.SpellExclusion;
import org.luwrain.nlp.SpellProblem;

final class MainLayout
extends LayoutBase {
    private final App app;
    final EditArea editArea;
    final MultilineEditModelWrap corrector;
    final EditSpellChecking spellChecking;
    final EditArea.ChangeListener modificationMarkListener;

    MainLayout(final App app) {
        super((AppBase)app);
        this.app = app;
        this.spellChecking = new EditSpellChecking(this.getLuwrain());
        this.modificationMarkListener = (area, lines, hotPoint) -> {
            app.modified = true;
        };
        this.editArea = new EditArea(this.editParams(params -> {
            params.name = "";
            params.appearance = new Appearance(params.context){

                @Override
                App.Mode getMode() {
                    return app.mode;
                }

                @Override
                public EditArea getEditArea() {
                    return MainLayout.this.editArea;
                }
            };
            params.changeListeners = Arrays.asList(this.modificationMarkListener);
            params.editFactory = p -> {
                p.model = new MultilineEditModelWrap(p.model);
                return new MultilineEdit(p);
            };
        })){

            public boolean onSystemEvent(SystemEvent event) {
                if (event.getType() == SystemEvent.Type.REGULAR) {
                    switch (event.getCode()) {
                        case SAVE: {
                            app.onSave();
                            return true;
                        }
                        case IDLE: {
                            return MainLayout.this.onIdle();
                        }
                    }
                }
                return super.onSystemEvent(event);
            }

            public boolean onAreaQuery(AreaQuery query) {
                if (query.getQueryCode() == 5 && query instanceof CurrentDirQuery) {
                    return MainLayout.this.onDirectoryQuery((CurrentDirQuery)query);
                }
                return super.onAreaQuery(query);
            }

            public String getAreaName() {
                if (app.file == null) {
                    return ((Strings)app.getStrings()).initialTitle();
                }
                return app.file.getName();
            }
        };
        this.corrector = (MultilineEditModelWrap)this.editArea.getEdit().getMultilineEditModel();
        this.setAreaLayout((Area)this.editArea, this.actions(new LayoutBase.ActionInfo[]{this.action("replace", ((Strings)app.getStrings()).actionReplace(), new InputEvent(InputEvent.Special.F5), this::actReplace), this.action("spell-right", ((Strings)app.getStrings()).actionSpellRight(), new InputEvent(InputEvent.Special.ARROW_RIGHT, EnumSet.of(InputEvent.Modifiers.SHIFT)), this::actFindSpellRight), this.action("word-suggestions", ((Strings)app.getStrings()).actionWordSuggestions(), new InputEvent(InputEvent.Special.F8), this::actWordSuggestions), this.action("add-spell-exclusion", ((Strings)app.getStrings()).actionAddSpellExclusion(), new InputEvent(InputEvent.Special.F8, EnumSet.of(InputEvent.Modifiers.SHIFT)), this::actAddSpellExclusion), this.action("charset", ((Strings)app.getStrings()).actionCharset(), new InputEvent(InputEvent.Special.F9), this::actCharset), this.action("narrating", ((Strings)app.getStrings()).actionNarrating(), new InputEvent(InputEvent.Special.F10), this::actNarrating), this.action("open", ((Strings)app.getStrings()).actionOpen(), new InputEvent(InputEvent.Special.F3, EnumSet.of(InputEvent.Modifiers.SHIFT)), this::actOpen), this.action("save-as", ((Strings)app.getStrings()).actionSaveAs(), new InputEvent(InputEvent.Special.F2, EnumSet.of(InputEvent.Modifiers.SHIFT)), this::actSaveAs), this.action("mode-none", ((Strings)app.getStrings()).modeNone(), new InputEvent(InputEvent.Special.F1, EnumSet.of(InputEvent.Modifiers.ALT)), this::actModeNone), this.action("mode-natural", ((Strings)app.getStrings()).modeNatural(), new InputEvent(InputEvent.Special.F2, EnumSet.of(InputEvent.Modifiers.ALT)), this::actModeNatural), this.action("mode-programming", ((Strings)app.getStrings()).modeProgramming(), new InputEvent(InputEvent.Special.F3, EnumSet.of(InputEvent.Modifiers.ALT)), this::actModeProgramming)}));
    }

    private boolean actReplace() {
        String oldValue = this.app.getConv().replaceExp();
        if (oldValue == null || oldValue.isEmpty()) {
            return true;
        }
        String newValue = this.app.getConv().replaceWith();
        if (newValue == null) {
            return true;
        }
        this.editArea.update((lines, hotPoint) -> {
            for (int i = 0; i < lines.getLineCount(); ++i) {
                lines.setLine(i, lines.getLine(i).replaceAll(oldValue, newValue));
            }
            return true;
        });
        return true;
    }

    private boolean actFindSpellRight() {
        AtomicBoolean moved = new AtomicBoolean(false);
        this.editArea.update((lines, hotPoint) -> {
            int index = hotPoint.getHotPointY();
            int len = lines.getLine(index).length();
            for (int i = 0; i < len; ++i) {
                LineMarks.Mark[] marks;
                LineMarks lineMarks = lines.getLineMarks(index);
                if (lineMarks == null || (marks = lineMarks.findAtPos(i)) == null || marks.length == 0) continue;
                for (LineMarks.Mark m : marks) {
                    if (m.getMarkObject() == null || !(m.getMarkObject() instanceof SpellProblem)) continue;
                    hotPoint.setHotPointX(i);
                    moved.set(true);
                    return false;
                }
            }
            if (!moved.get()) {
                return false;
            }
            this.getControlContext().onAreaNewHotPoint((Area)this.editArea);
            return true;
        });
        return true;
    }

    private boolean onIdle() {
        MutableMarkedLines lines = this.editArea.getContent();
        int x = this.editArea.getHotPointX();
        int y = this.editArea.getHotPointY();
        if (y >= lines.getLineCount()) {
            return true;
        }
        LineMarks marks = lines.getLineMarks(y);
        if (marks == null) {
            return true;
        }
        LineMarks.Mark[] atPoint = marks.findAtPos(x);
        if (atPoint == null || atPoint.length == 0) {
            return true;
        }
        for (LineMarks.Mark m : atPoint) {
            if (m.getMarkObject() == null || !(m.getMarkObject() instanceof SpellProblem)) continue;
            SpellProblem p = (SpellProblem)m.getMarkObject();
            this.app.message(p.getComment(), Luwrain.MessageType.ANNOUNCEMENT);
            return true;
        }
        return true;
    }

    private boolean onDirectoryQuery(CurrentDirQuery query) {
        if (this.app.file == null) {
            return false;
        }
        File f = this.app.file.getParentFile();
        if (f == null) {
            return false;
        }
        query.answer(f.getAbsolutePath());
        return true;
    }

    private boolean actOpen() {
        if (!this.app.everythingSaved()) {
            return true;
        }
        File file = this.app.getConv().open();
        if (file == null) {
            return true;
        }
        File origFile = this.app.file;
        this.app.file = file;
        try {
            this.setText(this.app.read());
        }
        catch (IOException e) {
            this.app.file = origFile;
            this.app.crash(e);
            return true;
        }
        this.app.setAppName(this.app.file.getName());
        this.editArea.reset(false);
        this.onNewFile();
        this.app.modified = false;
        return true;
    }

    private boolean actSaveAs() {
        File f = this.app.getConv().save(this.app.file);
        if (f == null) {
            return true;
        }
        this.app.file = f;
        this.onNewFile();
        try {
            this.app.save(this.editArea.getText());
        }
        catch (IOException e) {
            this.app.getLuwrain().crash((Throwable)e);
            return true;
        }
        this.app.modified = false;
        this.app.getLuwrain().message(((Strings)this.app.getStrings()).fileIsSaved(), Luwrain.MessageType.OK);
        return true;
    }

    private boolean actCharset() {
        if (!this.app.everythingSaved()) {
            return true;
        }
        String res = this.app.getConv().charset();
        if (res == null) {
            return true;
        }
        this.app.charset = res;
        if (this.app.file != null && this.app.getConv().rereadWithNewCharser(this.app.file)) {
            try {
                this.setText(this.app.read());
            }
            catch (IOException e) {
                this.app.getLuwrain().crash((Throwable)e);
                return true;
            }
        }
        return true;
    }

    private boolean actNarrating() {
        return this.app.narrating(this.editArea.getText());
    }

    private boolean actModeNone() {
        this.app.mode = App.Mode.NONE;
        this.editArea.setChangeListeners(Arrays.asList(this.modificationMarkListener));
        this.spellChecking.eraseSpellingMarks(this.editArea);
        this.app.message(((Strings)this.app.getStrings()).modeNone(), Luwrain.MessageType.OK);
        return true;
    }

    private boolean actModeNatural() {
        this.app.mode = App.Mode.NATURAL;
        this.editArea.setChangeListeners(Arrays.asList(this.modificationMarkListener, this.spellChecking));
        this.spellChecking.initialChecking(this.editArea);
        this.app.message(((Strings)this.app.getStrings()).modeNatural(), Luwrain.MessageType.OK);
        return true;
    }

    private boolean actModeProgramming() {
        this.app.mode = App.Mode.PROGRAMMING;
        this.spellChecking.eraseSpellingMarks(this.editArea);
        this.editArea.setChangeListeners(Arrays.asList(this.modificationMarkListener));
        this.app.message(((Strings)this.app.getStrings()).modeProgramming(), Luwrain.MessageType.OK);
        return true;
    }

    private boolean actWordSuggestions() {
        String word = new TextFragmentUtils((Lines)this.editArea.getContent()).getWord(this.editArea.getHotPointX(), this.editArea.getHotPointY());
        if (word == null) {
            return false;
        }
        List suggestions = this.spellChecking.getSpellChecker().suggestCorrections(word);
        if (suggestions != null && (suggestions == null || suggestions.isEmpty())) {
            return false;
        }
        String correction = this.app.getConv().correctionSuggestion(suggestions.toArray(new String[suggestions.size()]));
        if (correction == null) {
            return true;
        }
        this.editArea.update((lines, hotPoint) -> {
            String newLine = new TextFragmentUtils((Lines)lines).replaceWord(hotPoint.getHotPointX(), hotPoint.getHotPointY(), correction);
            lines.setLine(hotPoint.getHotPointY(), newLine);
            return true;
        });
        return true;
    }

    private boolean actAddSpellExclusion() {
        String word = new TextFragmentUtils((Lines)this.editArea.getContent()).getWord(this.editArea.getHotPointX(), this.editArea.getHotPointY());
        if (word == null) {
            return false;
        }
        for (SpellExclusion.Exclusion e : this.spellChecking.getSpellChecker().getExclusion().getExclusions()) {
            if (!e.getText().toUpperCase().equals(word.toUpperCase())) continue;
            this.getLuwrain().playSound(Sounds.OK);
            return true;
        }
        SpellExclusion.Exclusion e = new SpellExclusion.Exclusion();
        e.setText(word.toUpperCase());
        this.spellChecking.getSpellChecker().getExclusion().getExclusions().add(e);
        this.spellChecking.getSpellChecker().getExclusion().save();
        this.getLuwrain().playSound(Sounds.OK);
        return true;
    }

    void setText(String[] text) {
        this.editArea.update((lines, hotPoint) -> {
            lines.setLines(text);
            return false;
        });
        this.editArea.refresh();
    }

    void onNewFile() {
        this.app.getLuwrain().onAreaNewName((Area)this.editArea);
    }
}

