/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.mail;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.luwrain.app.mail.App;
import org.luwrain.app.mail.Strings;
import org.luwrain.core.Luwrain;
import org.luwrain.pim.mail.Message;
import org.luwrain.pim.mail.MessageContentItem;
import org.luwrain.pim.mail.persistence.MailPersistence;
import org.luwrain.pim.mail.persistence.dao.AccountDAO;
import org.luwrain.pim.mail.persistence.dao.FolderDAO;
import org.luwrain.pim.mail.persistence.dao.MessageDAO;
import org.luwrain.pim.mail.persistence.model.Account;
import org.luwrain.pim.mail.persistence.model.Folder;
import org.luwrain.util.TextUtils;

public final class Data {
    public final Strings strings;
    public final FolderDAO folderDAO;
    public final MessageDAO messageDAO;
    public final AccountDAO accountDAO;
    final File userSettingsFile;
    final List<String> messageLines = new ArrayList<String>();
    final List<MessageContentItem> messageAttachments = new ArrayList<MessageContentItem>();

    Data(Luwrain luwrain, Strings strings, File userSettingsFile) {
        MailPersistence persist = (MailPersistence)luwrain.createInstance(MailPersistence.class);
        this.folderDAO = persist.getFolderDAO();
        this.messageDAO = persist.getMessageDAO();
        this.accountDAO = persist.getAccountDAO();
        this.strings = strings;
        this.userSettingsFile = userSettingsFile;
        if (this.folderDAO.getRoot() == null) {
            this.createInitialFolders();
        }
    }

    List<Message> getMessagesInLocalFolder(int folderId) {
        List mm = this.messageDAO.getByFolderId(folderId);
        ArrayList<Message> m = new ArrayList<Message>();
        m.ensureCapacity(mm.size());
        mm.forEach(i -> m.add(new Message(i)));
        return m;
    }

    void setMessage(Message message) {
        this.messageLines.clear();
        this.messageAttachments.clear();
        this.messageLines.add(this.strings.messageAreaFrom() + " " + (message.getMetadata().getFromAddr() != null && !message.getMetadata().getFromAddr().trim().isEmpty() ? message.getMetadata().getFromAddr().trim() : "(\u0431\u0435\u0437 \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u0435\u043b\u044f)"));
        this.messageAttachments.add(null);
        this.messageLines.add(this.strings.messageAreaSubject() + " " + (message.getMetadata().getSubject() != null && !message.getMetadata().getSubject().trim().isEmpty() ? message.getMetadata().getSubject().trim() : "(\u0431\u0435\u0437 \u0442\u0435\u043c\u044b)"));
        this.messageAttachments.add(null);
        MessageContentItem plain = null;
        MessageContentItem plainAlternative = null;
        for (MessageContentItem i : message.getContentItems()) {
            boolean isTextPlain = i.getContentType().toLowerCase().startsWith("text/plain");
            if (isTextPlain) {
                if (i.isAlternative()) {
                    plainAlternative = i;
                } else {
                    plain = i;
                }
            }
            if (i.getDisposition() == null || !i.getDisposition().toLowerCase().startsWith("attachment")) continue;
            this.messageLines.add(i.getFileName());
            this.messageAttachments.add(i);
        }
        if (plain == null) {
            plain = plainAlternative;
        }
        if (plain != null && plain.getText() != null) {
            for (String s : TextUtils.splitLinesAnySeparator((String)plain.getText())) {
                this.messageLines.add(s.trim());
            }
        }
    }

    private void createInitialFolders() {
        String t = "true";
        Folder root = new Folder();
        root.setName("\u041f\u043e\u0447\u0442\u043e\u0432\u044b\u0435 \u0433\u0440\u0443\u043f\u043f\u044b");
        root.setId(0);
        root.setParentFolderId(0);
        this.folderDAO.add(root);
        Folder f = new Folder();
        f.setName("\u0412\u0445\u043e\u0434\u044f\u0449\u0438\u0435");
        f.getProperties().setProperty("default-incoming", "true");
        f.setParentFolderId(root.getId());
        this.folderDAO.add(f);
        f = new Folder();
        f.setName("\u0420\u0430\u0441\u0441\u044b\u043b\u043a\u0438");
        f.getProperties().setProperty("default-mailing-lists", "true");
        f.setParentFolderId(root.getId());
        this.folderDAO.add(f);
        f = new Folder();
        f.setName("\u0418\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0435");
        f.getProperties().setProperty("default-outgoing", "true");
        f.setParentFolderId(root.getId());
        this.folderDAO.add(f);
        f = new Folder();
        f.setName("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0435");
        f.getProperties().setProperty("default-sent", "true");
        f.setParentFolderId(root.getId());
        this.folderDAO.add(f);
        f = new Folder();
        f.setName("\u0427\u0435\u0440\u043d\u043e\u0432\u0438\u043a\u0438");
        f.setParentFolderId(root.getId());
        this.folderDAO.add(f);
    }

    private void createInitialAccounts() {
        if (!this.userSettingsFile.exists()) {
            return;
        }
        App.log.debug("User settings file is " + this.userSettingsFile.getAbsolutePath());
        try {
            Properties p = new Properties();
            try (BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.userSettingsFile), "UTF-8"));){
                p.load(r);
            }
            String pop3Host = p.getProperty("pop3.host");
            String pop3Port = p.getProperty("pop3.port");
            String pop3Login = p.getProperty("pop3.login");
            String pop3Passwd = p.getProperty("pop3.passwd");
            if (pop3Host != null && !pop3Host.trim().isEmpty() && pop3Login != null && !pop3Login.trim().isEmpty()) {
                Account a = new Account();
                a.setName("Automatically created from default settings POP3 account  on " + pop3Host.trim());
                a.setType(Account.Type.POP3);
                a.setHost(pop3Host.trim());
                a.setPort(pop3Port != null && !pop3Port.trim().isEmpty() ? Integer.parseInt(pop3Port.trim()) : 110);
                a.setPasswd(pop3Passwd.trim());
                a.setLogin(pop3Login.trim());
                a.setEnabled(true);
                a.setDefaultAccount(false);
                a.setLeaveMessages(true);
                a.setTrustedHosts("*");
                a.setSsl(true);
                this.accountDAO.add(a);
                App.log.debug("Added the POP3 account: host=" + a.getHost() + ", login=" + a.getLogin() + ", port=" + a.getPort());
            }
        }
        catch (Exception e) {
            App.log.error("Unable to load user accounts settings", (Throwable)e);
        }
    }
}

