/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.vk;

import com.vk.api.sdk.objects.wall.Wallpost;
import com.vk.api.sdk.objects.wall.WallpostAttachment;
import com.vk.api.sdk.objects.wall.WallpostAttachmentType;
import com.vk.api.sdk.objects.wall.WallpostFull;
import java.util.List;
import org.luwrain.app.vk.Actions;
import org.luwrain.app.vk.Base;
import org.luwrain.app.vk.Strings;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.core.Action;
import org.luwrain.core.Area;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.BkgSounds;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Event;
import org.luwrain.core.Hint;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.core.events.ActionEvent;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.core.queries.BackgroundSoundQuery;

class WallArea
extends ListArea {
    private final Luwrain luwrain;
    private final Strings strings;
    private final Base base;
    private final Actions actions;

    WallArea(Luwrain luwrain, Strings strings, Base base, Actions actions) {
        super(WallArea.createParams(luwrain, strings, base));
        this.luwrain = luwrain;
        this.strings = strings;
        this.base = base;
        this.actions = actions;
        this.showHome();
    }

    boolean showHome() {
        if (!this.actions.onHomeWallUpdate(() -> {
            this.refresh();
            this.reset(false);
            this.luwrain.setActiveArea((Area)this);
        })) {
            return false;
        }
        this.base.shownUser = null;
        return true;
    }

    boolean showUserInfo(int userId) {
        return this.actions.onUserInfoUpdate(userId, () -> {
            this.refresh();
            this.reset(false);
            this.luwrain.setActiveArea((Area)this);
        });
    }

    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.isSpecial() && !event.isModified()) {
            switch (event.getSpecial()) {
                case ESCAPE: {
                    if (this.base.shownUser != null) {
                        return this.showHome();
                    }
                    this.base.closeApp();
                    return true;
                }
            }
        }
        return super.onInputEvent(event);
    }

    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.getType() != SystemEvent.Type.REGULAR) {
            return super.onSystemEvent(event);
        }
        switch (event.getCode()) {
            case ACTION: {
                if (ActionEvent.isAction((Event)event, (String)"delete")) {
                    Object selected = this.selected();
                    if (selected == null || !(selected instanceof WallpostFull)) {
                        return false;
                    }
                    if (!this.actions.onWallDelete((WallpostFull)selected, () -> {
                        this.refresh();
                        this.luwrain.onAreaNewBackgroundSound((Area)this);
                        this.luwrain.playSound(Sounds.OK);
                    })) {
                        return false;
                    }
                    this.luwrain.onAreaNewBackgroundSound((Area)this);
                    return true;
                }
                return super.onSystemEvent(event);
            }
            case CLOSE: {
                this.base.closeApp();
                return true;
            }
        }
        return super.onSystemEvent(event);
    }

    public boolean onAreaQuery(AreaQuery query) {
        NullCheck.notNull((Object)query, (String)"query");
        switch (query.getQueryCode()) {
            case 7: {
                if (this.base.isBusy()) {
                    ((BackgroundSoundQuery)query).answer(new BackgroundSoundQuery.Answer(BkgSounds.FETCHING));
                    return true;
                }
                return false;
            }
        }
        return super.onAreaQuery(query);
    }

    public Action[] getAreaActions() {
        return this.actions.lists.getWallActions();
    }

    private static ListArea.Params createParams(Luwrain luwrain, Strings strings, Base base) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull((Object)strings, (String)"strings");
        NullCheck.notNull((Object)base, (String)"base");
        ListArea.Params params = new ListArea.Params();
        params.context = new DefaultControlContext(luwrain);
        params.model = new Model(base);
        params.appearance = new Appearance(luwrain, strings);
        params.name = strings.wallAreaName();
        return params;
    }

    private static final class Model
    implements ListArea.Model {
        private final Base base;

        Model(Base base) {
            NullCheck.notNull((Object)base, (String)"base");
            this.base = base;
        }

        public int getItemCount() {
            NullCheck.notNullItems((Object[])this.base.wallPosts, (String)"base.wallPosts");
            NullCheck.notNullItems((Object[])this.base.shownUserWallPosts, (String)"base.shownUserWallPosts");
            if (this.base.shownUser != null) {
                return this.base.shownUserWallPosts.length + 5;
            }
            return this.base.wallPosts.length;
        }

        public Object getItem(int index) {
            NullCheck.notNullItems((Object[])this.base.wallPosts, (String)"base.wallPOsts");
            NullCheck.notNullItems((Object[])this.base.shownUserWallPosts, (String)"base.shownUserWallPosts");
            if (this.base.shownUser != null) {
                switch (index) {
                    case 0: {
                        return new Section(this.base.shownUser.getFirstName() + " " + this.base.shownUser.getLastName());
                    }
                    case 1: {
                        StringBuilder b = new StringBuilder();
                        b.append("\u0414\u0430\u0442\u0430 \u0440\u043e\u0436\u0434\u0435\u043d\u0438\u044f:");
                        if (this.base.shownUser.getBdate() != null && !this.base.shownUser.getBdate().trim().isEmpty()) {
                            b.append(" ").append(this.base.shownUser.getBdate().trim());
                        }
                        return new String(b);
                    }
                    case 2: {
                        StringBuilder b = new StringBuilder();
                        b.append("\u041e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u0435/\u0440\u0430\u0431\u043e\u0442\u0430:");
                        if (this.base.shownUser.getOccupation() != null && this.base.shownUser.getOccupation().getName() != null && !this.base.shownUser.getOccupation().getName().trim().isEmpty()) {
                            b.append(" ").append(this.base.shownUser.getOccupation().getName().trim());
                        }
                        return new String(b);
                    }
                    case 3: {
                        StringBuilder b = new StringBuilder();
                        b.append("\u0418\u043d\u0442\u0435\u0440\u0435\u0441\u044b:");
                        return new String(b);
                    }
                    case 4: {
                        return new Section("\u0421\u0442\u0435\u043d\u0430");
                    }
                }
                return this.base.shownUserWallPosts[index - 5];
            }
            return this.base.wallPosts[index];
        }

        public void refresh() {
        }
    }

    private static final class Appearance
    extends ListUtils.DoubleLevelAppearance {
        private final Luwrain luwrain;
        private final Strings strings;

        Appearance(Luwrain luwrain, Strings strings) {
            super((ControlContext)new DefaultControlContext(luwrain));
            NullCheck.notNull((Object)luwrain, (String)"luwrain");
            NullCheck.notNull((Object)strings, (String)"strings");
            this.luwrain = luwrain;
            this.strings = strings;
        }

        public boolean isSectionItem(Object item) {
            NullCheck.notNull((Object)item, (String)"item");
            return item instanceof Section;
        }

        public void announceNonSection(Object item) {
            NullCheck.notNull((Object)item, (String)"item");
            if (item instanceof WallpostFull) {
                String text;
                WallpostFull full = (WallpostFull)item;
                Object extInfo = "";
                if (full.getLikes() != null && full.getLikes().getCount() != null) {
                    extInfo = full.getLikes().getCount() + " ";
                }
                Wallpost post = this.getOrigPost((WallpostFull)item);
                boolean picture = false;
                List attachments = post.getAttachments();
                if (attachments != null) {
                    for (WallpostAttachment a : attachments) {
                        if (a.getType() != WallpostAttachmentType.PHOTO && a.getType() != WallpostAttachmentType.POSTED_PHOTO) continue;
                        picture = true;
                    }
                }
                if ((text = this.getText(post)).isEmpty()) {
                    this.luwrain.setEventResponse(DefaultEventResponse.hint((Hint)Hint.EMPTY_LINE));
                    return;
                }
                this.luwrain.setEventResponse(DefaultEventResponse.listItem((Sounds)(picture ? Sounds.PICTURE : Sounds.LIST_ITEM), (String)((String)extInfo + text), null));
                return;
            }
            this.luwrain.setEventResponse(DefaultEventResponse.listItem((Sounds)Sounds.LIST_ITEM, (String)item.toString(), null));
        }

        public String getNonSectionScreenAppearance(Object item) {
            NullCheck.notNull((Object)item, (String)"item");
            if (item instanceof WallpostFull) {
                Wallpost post = this.getOrigPost((WallpostFull)item);
                return this.getText(post);
            }
            return item.toString();
        }

        private String getText(Wallpost post) {
            NullCheck.notNull((Object)post, (String)"post");
            boolean picture = false;
            List attachments = post.getAttachments();
            if (attachments != null) {
                for (WallpostAttachment a : attachments) {
                    if (a.getType() != WallpostAttachmentType.PHOTO && a.getType() != WallpostAttachmentType.POSTED_PHOTO) continue;
                    picture = true;
                }
            }
            if (post.getText() != null && !post.getText().trim().isEmpty()) {
                return post.getText().trim();
            }
            if (picture) {
                return "[\u0424\u041e\u0422\u041e]";
            }
            return "";
        }

        private Wallpost getOrigPost(WallpostFull post) {
            NullCheck.notNull((Object)post, (String)"post");
            if (post.getCopyHistory() == null || post.getCopyHistory().isEmpty()) {
                return post;
            }
            return (Wallpost)post.getCopyHistory().get(post.getCopyHistory().size() - 1);
        }
    }

    private static final class Section {
        final String str;

        Section(String str) {
            NullCheck.notNull((Object)str, (String)"str");
            this.str = str;
        }

        public String toString() {
            return this.str;
        }

        public boolean equals(Object sect) {
            if (sect == null || !(sect instanceof Section)) {
                return false;
            }
            return this.str.equals(((Section)sect).str);
        }
    }
}

