/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.vk2;

import com.vk.api.sdk.objects.newsfeed.ItemWallpost;
import com.vk.api.sdk.oneofs.NewsfeedNewsfeedItemOneOf;
import java.util.Set;
import org.luwrain.app.vk2.App;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Hint;
import org.luwrain.core.Log;
import org.luwrain.core.Sounds;
import org.luwrain.core.Suggestions;

final class NewsAppearance
extends ListUtils.AbstractAppearance<NewsfeedNewsfeedItemOneOf> {
    final App app;

    NewsAppearance(App app) {
        this.app = app;
    }

    public void announceItem(NewsfeedNewsfeedItemOneOf item, Set<ListArea.Appearance.Flags> flags) {
        try {
            ItemWallpost post = item.getOneOf0();
            String userName = this.app.getUserCommonName(post.getSourceId());
            switch (post.getType()) {
                case POST: {
                    if (post.getText() != null) {
                        this.app.setEventResponse(DefaultEventResponse.listItem((Sounds)Sounds.LIST_ITEM, (String)(userName + " " + post.getText()), (Suggestions)Suggestions.CLICKABLE_LIST_ITEM));
                        break;
                    }
                    this.app.setEventResponse(DefaultEventResponse.hint((Hint)Hint.EMPTY_LINE));
                    break;
                }
                case FRIEND: {
                    this.app.setEventResponse(DefaultEventResponse.listItem((Sounds)Sounds.LIST_ITEM, (String)userName, null));
                    break;
                }
                default: {
                    this.app.setEventResponse(DefaultEventResponse.listItem((Sounds)Sounds.LIST_ITEM, (String)post.getType().toString(), null));
                    break;
                }
            }
        }
        catch (Exception e) {
            Log.error((String)"vk", (String)("unable to parse news feed item: " + e.getClass().getName() + ": " + e.getMessage()));
            this.app.setEventResponse(DefaultEventResponse.listItem((Sounds)Sounds.ALERT, (String)item.getRaw().toString(), null));
        }
    }

    public String getScreenAppearance(NewsfeedNewsfeedItemOneOf item, Set<ListArea.Appearance.Flags> flags) {
        try {
            ItemWallpost post = item.getOneOf0();
            return post.getText() != null ? post.getText().trim() : "";
        }
        catch (Exception e) {
            return item.getRaw().toString();
        }
    }
}

