/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.graphical;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javafx.application.Platform;
import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;

public final class FxThread {
    private static final String LOG_COMPONENT = "fx";

    public static void ensure() {
        if (!Platform.isFxApplicationThread()) {
            throw new IllegalStateException("Execution in non-jfx thread");
        }
    }

    public static Object call(Callable<Object> callable) {
        NullCheck.notNull(callable, (String)"callable");
        if (Platform.isFxApplicationThread()) {
            try {
                return callable.call();
            }
            catch (Throwable e) {
                Log.error((String)LOG_COMPONENT, (String)("callable object thrown an exception: " + e.getClass().getName() + ": " + e.getMessage()));
                throw new RuntimeException(e);
            }
        }
        FutureTask<Object> query = new FutureTask<Object>(callable);
        Platform.runLater(query);
        try {
            return query.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException e) {
            Log.error((String)LOG_COMPONENT, (String)("execution exception during processing of the callable object: " + e.getClass().getName() + ": " + e.getMessage()));
            throw new RuntimeException(e);
        }
    }

    public static void runSync(Runnable runnable) {
        NullCheck.notNull((Object)runnable, (String)"runnable");
        if (Platform.isFxApplicationThread()) {
            runnable.run();
            return;
        }
        FutureTask<Object> query = new FutureTask<Object>(runnable, null);
        Platform.runLater(query);
        try {
            query.get();
            return;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static void runAsync(Runnable runnable) {
        NullCheck.notNull((Object)runnable, (String)"runnable");
        if (Platform.isFxApplicationThread()) {
            try {
                runnable.run();
                return;
            }
            catch (Throwable e) {
                Log.error((String)LOG_COMPONENT, (String)("runnable object has thrown an exception:" + e.getClass().getName() + ":" + e.getMessage()));
                throw new RuntimeException(e);
            }
        }
        FutureTask<Object> query = new FutureTask<Object>(runnable, null);
        Platform.runLater(query);
    }
}

