/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.i18n.ru;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.luwrain.core.HookContainer;
import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.inlandes.Inlandes;
import org.luwrain.inlandes.Token;
import org.luwrain.script.Hooks;

final class SpeakableText {
    private static final String LOG_COMPONENT = "ru";
    private static final String HOOK_PROGRAMMING = "luwrain.i18n.ru.speakable.programming";
    private final HookContainer hookContainer;
    private final Inlandes inlandes = new Inlandes();

    SpeakableText(HookContainer hookContainer) {
        this.hookContainer = hookContainer;
        this.inlandes.loadStandardLibrary();
        this.loadRules();
    }

    String process(String text, Luwrain.SpeakableTextType type) {
        switch (type) {
            case NATURAL: {
                return this.processNatural(text);
            }
            case PROGRAMMING: {
                return Hooks.transformer((HookContainer)this.hookContainer, (String)HOOK_PROGRAMMING, (Object)text).toString();
            }
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String processNatural(String text) {
        Inlandes inlandes = this.inlandes;
        synchronized (inlandes) {
            return Token.concatText((Token[])this.inlandes.process(text));
        }
    }

    private void loadRules() {
        try (BufferedReader r = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("rules"), "UTF-8"));){
            String line = r.readLine();
            StringBuilder b = new StringBuilder();
            while (line != null) {
                String l = line.trim();
                if (!l.isEmpty() && l.charAt(0) != '#') {
                    b.append(line).append(System.lineSeparator());
                }
                line = r.readLine();
            }
            this.inlandes.loadRules(new String(b));
        }
        catch (Throwable e) {
            Log.error((String)LOG_COMPONENT, (String)("unable to load Inlandes rules: " + e.getClass().getName() + ": " + e.getMessage()));
        }
    }
}

