/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.commander;

import java.util.ArrayList;
import org.apache.commons.vfs2.FileObject;
import org.graalvm.polyglot.Value;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.commander.App;
import org.luwrain.app.commander.MainLayout;
import org.luwrain.app.commander.PanelArea;
import org.luwrain.core.HookContainer;
import org.luwrain.script.ScriptUtils;

final class Hooks {
    private static final String PANEL_ACTIONS = "luwrain.commander.panel.actions";
    private final App app;

    Hooks(App app) {
        this.app = app;
    }

    LayoutBase.ActionInfo[] panelActions(MainLayout layout, PanelArea panelArea, PanelArea otherPanelArea) {
        ArrayList<LayoutBase.ActionInfo> res = new ArrayList<LayoutBase.ActionInfo>();
        Object[] items = org.luwrain.script.Hooks.collectorForArrays((HookContainer)this.app.getLuwrain(), (String)PANEL_ACTIONS, (Object[])new Object[0]);
        if (items == null) {
            return new LayoutBase.ActionInfo[0];
        }
        for (Object item : items) {
            Value action;
            String name = ScriptUtils.asString((Object)ScriptUtils.getMember((Object)item, (String)"name"));
            String title = ScriptUtils.asString((Object)ScriptUtils.getMember((Object)item, (String)"title"));
            if (name == null || name.trim().isEmpty() || title == null || title.trim().isEmpty() || (action = ScriptUtils.getMember((Object)item, (String)"action")) == null || action.isNull() || !action.canExecute()) continue;
            res.add(layout.action(name.trim(), title.trim(), () -> {
                ArrayList<String> marked = new ArrayList<String>();
                String selected = panelArea.getSelectedEntry() != null ? PanelArea.asFile((FileObject)panelArea.getSelectedEntry()).getAbsolutePath() : null;
                for (FileObject o : panelArea.getToProcess()) {
                    marked.add(PanelArea.asFile(o).getAbsolutePath());
                }
                Value actRes = action.execute(new Object[]{selected, ScriptUtils.getArray(marked)});
                if (actRes == null || actRes.isNull() || !actRes.isBoolean()) {
                    return false;
                }
                return actRes.asBoolean();
            }));
        }
        return res.toArray(new LayoutBase.ActionInfo[res.size()]);
    }
}

