/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.commander;

import java.util.Set;
import org.luwrain.app.commander.App;
import org.luwrain.app.commander.Strings;
import org.luwrain.app.commander.fileops.Operation;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;

class OperationsAppearance
extends ListUtils.AbstractAppearance<Operation> {
    private final App app;
    private final Luwrain luwrain;
    private final Strings strings;

    OperationsAppearance(App app) {
        NullCheck.notNull((Object)((Object)app), (String)"app");
        this.luwrain = app.getLuwrain();
        this.strings = (Strings)app.getStrings();
        this.app = app;
    }

    public void announceItem(Operation op, Set<ListArea.Appearance.Flags> flags) {
        NullCheck.notNull((Object)op, (String)"op");
        NullCheck.notNull(flags, (String)"flags");
        Sounds sound = op.isDone() ? (op.getException() == null ? Sounds.SELECTED : Sounds.ATTENTION) : Sounds.LIST_ITEM;
        this.luwrain.setEventResponse(DefaultEventResponse.listItem((Sounds)sound, (String)op.name, null));
    }

    public String getScreenAppearance(Operation op, Set<ListArea.Appearance.Flags> flags) {
        NullCheck.notNull((Object)op, (String)"op");
        NullCheck.notNull(flags, (String)"flags");
        return op.name;
    }
}

