/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.commander.fileops;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import org.luwrain.app.commander.fileops.OperationListener;
import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;

public abstract class Operation
implements Runnable {
    public static final String INTERRUPTED = "LWR_INTERRUPTED";
    public static final String SOURCE_IS_A_PARENT_OF_THE_DEST = "LWR_SOURCE_IS_A_PARENT_OF_THE_DEST";
    public static final String MOVE_DEST_NOT_DIR = "LWR_MOVE_DEST_NOT_DIR";
    private final OperationListener listener;
    public final String name;
    private boolean finished = false;
    private Throwable ex = null;
    private boolean finishingAccepted = false;
    protected boolean interrupted = false;

    Operation(OperationListener listener, String name) {
        this.listener = listener;
        this.name = name;
    }

    protected abstract void work() throws IOException;

    public abstract int getPercent();

    @Override
    public void run() {
        this.ex = null;
        try {
            try {
                this.work();
            }
            catch (Throwable e) {
                Log.error((String)"commander", (String)(this.name + ": " + e.getClass().getSimpleName() + ": " + e.getMessage()));
                e.printStackTrace();
                this.ex = e;
            }
        }
        finally {
            this.finished = true;
            this.listener.onOperationProgress(this);
        }
    }

    public synchronized void interrupt() {
        this.interrupted = true;
    }

    public boolean isDone() {
        return this.finished;
    }

    public boolean finishingAccepted() {
        if (this.finishingAccepted) {
            return true;
        }
        this.finishingAccepted = true;
        return false;
    }

    public Throwable getException() {
        return this.ex;
    }

    protected static boolean isDirectory(Path path, boolean followSymlinks) throws IOException {
        if (followSymlinks) {
            return Files.isDirectory(path, new LinkOption[0]);
        }
        return Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS);
    }

    protected static Path[] getDirContent(Path path) throws IOException {
        ArrayList<Path> res = new ArrayList<Path>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            for (Path p : directoryStream) {
                res.add(p);
            }
        }
        return res.toArray(new Path[res.size()]);
    }

    protected static boolean isRegularFile(Path path, boolean followSymlinks) throws IOException {
        if (followSymlinks) {
            return Files.isRegularFile(path, new LinkOption[0]);
        }
        return Files.isRegularFile(path, LinkOption.NOFOLLOW_LINKS);
    }

    protected static boolean exists(Path path, boolean followSymlinks) throws IOException {
        if (followSymlinks) {
            return Files.exists(path, new LinkOption[0]);
        }
        return Files.exists(path, LinkOption.NOFOLLOW_LINKS);
    }

    protected void deleteFileOrDir(Path p) throws IOException {
        if (Operation.isDirectory(p, false)) {
            Path[] content;
            for (Path pp : content = Operation.getDirContent(p)) {
                this.deleteFileOrDir(pp);
            }
        }
        Files.delete(p);
    }

    protected void status(String message) {
        Log.debug((String)"fileops", (String)message);
    }

    protected ConfirmationChoices confirmOverwrite(Path path) {
        return null;
    }

    protected void onProgress(Operation op) {
        NullCheck.notNull((Object)op, (String)"op");
        this.listener.onOperationProgress(op);
    }

    static long getTotalSize(Path p) throws IOException {
        if (Files.isRegularFile(p, LinkOption.NOFOLLOW_LINKS)) {
            return Files.size(p);
        }
        if (!Files.isDirectory(p, LinkOption.NOFOLLOW_LINKS)) {
            return 0L;
        }
        long res = 0L;
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(p);){
            for (Path pp : directoryStream) {
                res += Operation.getTotalSize(pp);
            }
        }
        return res;
    }

    protected static void ensureValidLocalPath(Path[] path) {
        for (Path p : path) {
            Operation.ensureValidLocalPath(p);
        }
    }

    protected static void ensureValidLocalPath(Path path) {
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException(path.toString() + " can't be relative");
        }
    }

    public static enum ConfirmationChoices {
        OVERWRITE,
        SKIP,
        CANCEL;

    }
}

