/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.commander.layouts;

import java.util.ArrayList;
import java.util.List;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.commander.App;
import org.luwrain.controls.NavigationArea;
import org.luwrain.core.Area;
import org.luwrain.core.Job;
import org.luwrain.core.events.InputEvent;

public final class CommandOutputLayout
extends LayoutBase {
    final App app;
    final Job job;
    final List<String> text = new ArrayList<String>();
    final NavigationArea area;

    public CommandOutputLayout(App app, final Job job) {
        super((AppBase)app);
        this.app = app;
        this.job = job;
        this.area = new NavigationArea(this.getControlContext()){

            public String getLine(int index) {
                return index < CommandOutputLayout.this.text.size() ? CommandOutputLayout.this.text.get(index) : "";
            }

            public int getLineCount() {
                return Math.max(CommandOutputLayout.this.text.size(), 1);
            }

            public String getAreaName() {
                return job.getInstanceName();
            }
        };
        LayoutBase.Actions actions = this.actions(new LayoutBase.ActionInfo[]{this.action("cancel", "cancel", new InputEvent(InputEvent.Special.F5), this::onCancel)});
        this.setAreaLayout((Area)this.area, actions);
        this.setCloseHandler(() -> {
            app.layouts().main();
            return true;
        });
    }

    boolean onCancel() {
        this.job.stop();
        return true;
    }

    public void update(List<String> text) {
        this.text.clear();
        this.text.addAll(text);
        this.area.redraw();
    }
}

