/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.reader;

import java.net.MalformedURLException;
import java.net.URL;
import org.luwrain.app.reader.books.AudioFragment;
import org.luwrain.app.reader.books.Book;
import org.luwrain.controls.reader.ReaderArea;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.player.FixedPlaylist;
import org.luwrain.player.Listener;
import org.luwrain.player.Player;
import org.luwrain.player.Playlist;
import org.luwrain.reader.Document;
import org.luwrain.reader.ExtraInfo;
import org.luwrain.reader.ListItem;
import org.luwrain.reader.Node;
import org.luwrain.reader.Paragraph;
import org.luwrain.reader.Run;
import org.luwrain.reader.Section;
import org.luwrain.reader.Table;
import org.luwrain.reader.TableCell;
import org.luwrain.reader.TableRow;
import org.luwrain.reader.Visitor;

class AudioPlaying
implements Listener {
    private final Luwrain luwrain;
    private final Player player;
    private ReaderArea area = null;
    private Run prevRun = null;
    private Book book = null;
    private Document doc = null;
    private Playlist currentPlaylist = null;

    AudioPlaying(Luwrain luwrain) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        this.luwrain = luwrain;
        this.player = luwrain.getPlayer();
        if (this.player != null) {
            this.player.addListener((Listener)this);
        }
    }

    boolean isLoaded() {
        return this.player != null;
    }

    boolean playAudio(Book book, Document doc, ReaderArea area, String[] ids) {
        NullCheck.notNull((Object)book, (String)"book");
        NullCheck.notNull((Object)doc, (String)"doc");
        NullCheck.notNull((Object)area, (String)"area");
        NullCheck.notNullItems((Object[])ids, (String)"ids");
        URL url = doc.getUrl();
        if (url == null) {
            return false;
        }
        for (String id : ids) {
            URL audioFileUrl;
            AudioFragment audioInfo = book.findAudioForId(url.toString() + "#" + id);
            if (audioInfo == null) continue;
            try {
                audioFileUrl = new URL(url, audioInfo.src);
            }
            catch (MalformedURLException e) {
                continue;
            }
            this.book = book;
            this.doc = doc;
            this.area = area;
            this.currentPlaylist = new FixedPlaylist(audioFileUrl.toString());
            this.player.play(this.currentPlaylist, 0, audioInfo.beginPosMsec(), Player.DEFAULT_FLAGS);
            this.luwrain.silence();
            return true;
        }
        return false;
    }

    boolean stop() {
        if (this.player.getState() != Player.State.PLAYING || this.currentPlaylist != this.player.getPlaylist()) {
            return false;
        }
        this.player.stop();
        return true;
    }

    public void onTrackTime(Playlist playlist, int trackNum, long msec) {
        NullCheck.notNull((Object)playlist, (String)"playlist");
        if (this.doc == null || this.book == null || this.area == null) {
            return;
        }
        if (this.doc.getUrl() == null) {
            return;
        }
        if (playlist != this.currentPlaylist) {
            return;
        }
        if (trackNum >= playlist.getTrackCount()) {
            return;
        }
        String track = playlist.getTrackUrl(trackNum);
        String link = this.book.findTextForAudio(track, msec);
        if (link == null) {
            return;
        }
        URL url = null;
        URL docUrl = null;
        try {
            url = new URL(link);
            docUrl = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile());
        }
        catch (MalformedURLException e) {
            return;
        }
        if (!this.doc.getUrl().equals(docUrl)) {
            return;
        }
        if (url.getRef().isEmpty()) {
            return;
        }
        AudioFollowingVisitor visitor = new AudioFollowingVisitor(url.getRef());
        Visitor.walk(this.doc.getRoot(), visitor);
        Run resultingRun = visitor.result();
        if (resultingRun == null || this.prevRun == resultingRun) {
            return;
        }
        this.luwrain.runUiSafely(() -> this.area.findRun(resultingRun));
        this.prevRun = resultingRun;
    }

    public void onNewPlaylist(Playlist playlist) {
        if (playlist != null && playlist != this.currentPlaylist) {
            this.onPlayerStop();
        }
    }

    public void onNewTrack(Playlist playlist, int trackNum) {
    }

    public void onNewState(Playlist playlist, Player.State state) {
        NullCheck.notNull((Object)state, (String)"state");
        if (playlist != this.currentPlaylist) {
            return;
        }
        if (state == Player.State.STOPPED) {
            this.onPlayerStop();
        }
    }

    public void onPlayingError(Playlist playlist, Exception error) {
    }

    private void onPlayerStop() {
        this.currentPlaylist = null;
        this.book = null;
        this.doc = null;
        this.area = null;
        this.prevRun = null;
    }

    private static final class AudioFollowingVisitor
    implements Visitor {
        private String desiredId;
        private Run resultingRun = null;

        AudioFollowingVisitor(String desiredId) {
            NullCheck.notEmpty((Object)desiredId, (String)"desiredId");
            this.desiredId = desiredId;
        }

        @Override
        public void visit(Paragraph para) {
            NullCheck.notNull((Object)para, (String)"para");
            if (this.resultingRun != null) {
                return;
            }
            for (Run r : para.getRuns()) {
                this.checkRun(r);
            }
        }

        @Override
        public void visitNode(Node node) {
        }

        @Override
        public void visit(ListItem node) {
        }

        @Override
        public void visit(Section node) {
        }

        @Override
        public void visit(TableCell node) {
        }

        @Override
        public void visit(Table node) {
        }

        @Override
        public void visit(TableRow node) {
        }

        private void checkRun(Run run) {
            if (this.resultingRun != null) {
                return;
            }
            ExtraInfo info = run.extraInfo();
            while (info != null) {
                if (info.attrs.containsKey("id") && info.attrs.get("id").equals(this.desiredId)) {
                    this.resultingRun = run;
                    return;
                }
                info = info.parent;
            }
        }

        Run result() {
            return this.resultingRun;
        }
    }
}

