/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.reader;

import org.luwrain.app.reader.Strings;
import org.luwrain.core.Luwrain;
import org.luwrain.core.MutableLines;
import org.luwrain.core.NullCheck;
import org.luwrain.reader.Document;

final class DocProps {
    private final Luwrain luwrain;
    private final Strings strings;
    private final Document doc;

    DocProps(Luwrain luwrain, Strings strings, Document doc) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull((Object)strings, (String)"strings");
        NullCheck.notNull((Object)doc, (String)"doc");
        this.luwrain = luwrain;
        this.strings = strings;
        this.doc = doc;
    }

    boolean fillProperties(MutableLines lines) {
        NullCheck.notNull((Object)lines, (String)"lines");
        lines.update(text -> {
            text.addLine("");
            text.addLine(this.strings.propertiesAreaUrl(this.doc.getProperty("url")));
            text.addLine(this.strings.propertiesAreaContentType(this.doc.getProperty("contenttype")));
            text.addLine("");
        });
        return true;
    }
}

