/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.reader.books;

import java.io.IOException;
import java.util.Set;
import org.luwrain.app.reader.books.AudioFragment;
import org.luwrain.core.NullCheck;
import org.luwrain.reader.Document;

public interface Book {
    public String getBookId();

    public Set<Flags> getBookFlags();

    public Section[] getBookSections();

    public Document getDocument(String var1) throws IOException;

    public Document getDefaultDocument();

    public AudioFragment findAudioForId(String var1);

    public String findTextForAudio(String var1, long var2);

    public static final class Section {
        public final int level;
        public final String title;
        public final String href;

        public Section(int level, String title, String href) {
            NullCheck.notNull((Object)title, (String)"title");
            NullCheck.notNull((Object)href, (String)"href");
            if (level < 0) {
                throw new IllegalArgumentException("level (" + String.valueOf(level) + ") can't be negative");
            }
            this.level = level;
            this.title = title;
            this.href = href;
        }

        public String toString() {
            return this.title;
        }
    }

    public static enum Flags {
        OPEN_IN_SECTION_TREE;

    }
}

