/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.reader.books;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.luwrain.core.NullCheck;

class Encoding {
    private static final Pattern pattern1 = Pattern.compile("<?xml.*encoding\\s*=\\s*\"([^\"]*)\".*?>", 2);
    private static final Pattern pattern2 = Pattern.compile("<?xml.*encoding\\s*=\\s*'([^']*)'.*?>", 2);

    Encoding() {
    }

    static String getHtmlEncoding(Path path) throws IOException {
        NullCheck.notNull((Object)path, (String)"path");
        Document doc = Jsoup.parse((InputStream)Files.newInputStream(path, new OpenOption[0]), (String)"US-ASCII", (String)path.toString());
        Elements el = doc.getElementsByTag("meta");
        for (Element e : el) {
            String res;
            MimeType mime;
            String content;
            String cs = e.attr("charset");
            if (cs != null && !cs.isEmpty()) {
                return cs;
            }
            String httpEquiv = e.attr("http-equiv");
            if (httpEquiv == null || !httpEquiv.trim().toLowerCase().equals("content-type") || (content = e.attr("content")) == null || content.isEmpty()) continue;
            try {
                mime = new MimeType(content);
            }
            catch (MimeTypeParseException ex) {
                ex.printStackTrace();
                continue;
            }
            String baseType = mime.getBaseType();
            if (baseType == null || !baseType.trim().toLowerCase().equals("text/html") || (res = mime.getParameter("charset")) == null || res.trim().isEmpty()) continue;
            return res.trim();
        }
        return "";
    }

    static String getXmlEncoding(InputStream s) throws IOException {
        String line;
        NullCheck.notNull((Object)s, (String)"s");
        BufferedReader r = new BufferedReader(new InputStreamReader(s));
        while ((line = r.readLine()) != null) {
            Matcher matcher = pattern1.matcher(line);
            if (matcher.find()) {
                return matcher.group(1);
            }
            matcher = pattern2.matcher(line);
            if (!matcher.find()) continue;
            return matcher.group(1);
        }
        return null;
    }

    static String getXmlEncoding(Path path) throws IOException {
        NullCheck.notNull((Object)path, (String)"path");
        try (InputStream is = null;){
            is = Files.newInputStream(path, new OpenOption[0]);
            String string = Encoding.getXmlEncoding(is);
            return string;
        }
    }
}

