/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls.reader.view;

import java.util.ArrayList;
import java.util.List;
import org.luwrain.controls.reader.view.RowPart;
import org.luwrain.controls.reader.view.RowPartsSplitter;
import org.luwrain.core.NullCheck;
import org.luwrain.reader.EmptyLine;
import org.luwrain.reader.Node;
import org.luwrain.reader.Paragraph;
import org.luwrain.reader.Run;

final class DefaultRowPartsBuilder {
    private static final String LOG_COMPONENT = "doctree";
    private final List<RowPart> parts = new ArrayList<RowPart>();
    private final List<Paragraph> paragraphs = new ArrayList<Paragraph>();

    DefaultRowPartsBuilder() {
    }

    void onNode(Node node) {
        NullCheck.notNull((Object)node, (String)"node");
        this.onNode(node, 0);
    }

    void onNode(Node node, int width) {
        NullCheck.notNull((Object)node, (String)"node");
        if (node instanceof EmptyLine) {
            Paragraph para = (Paragraph)node;
            RowPart part = new RowPart(para.getRuns()[0]);
            this.parts.add(part);
            return;
        }
        if (node instanceof Paragraph) {
            this.onParagraph((Paragraph)node, width);
            return;
        }
        for (Node n : node.getSubnodes()) {
            this.onNode(n);
        }
    }

    private void onParagraph(Paragraph para, int width) {
        NullCheck.notNull((Object)para, (String)"para");
        RowPartsSplitter splitter = new RowPartsSplitter();
        for (Run r : para.getRuns()) {
            String text = r.text();
            NullCheck.notNull((Object)text, (String)"text");
            splitter.onRun(r, text, 0, text.length(), width > 0 ? width : para.width);
        }
        if (!splitter.res.isEmpty()) {
            this.paragraphs.add(para);
            for (RowPart p : splitter.res) {
                this.parts.add(p);
            }
        }
    }

    private static RowPart makeTitlePart(Run run) {
        NullCheck.notNull((Object)run, (String)"run");
        return new RowPart(run);
    }

    RowPart[] getRowParts() {
        return this.parts.toArray(new RowPart[this.parts.size()]);
    }

    Paragraph[] getParagraphs() {
        return this.paragraphs.toArray(new Paragraph[this.paragraphs.size()]);
    }
}

