/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls.reader.view;

import org.luwrain.core.NullCheck;
import org.luwrain.reader.Run;

final class RowPart {
    final Run run;
    final int posFrom;
    final int posTo;
    final int relRowNum;
    int absRowNum = 0;

    RowPart(Run run) {
        NullCheck.notNull((Object)run, (String)"run");
        this.run = run;
        this.posFrom = -1;
        this.posTo = -1;
        this.relRowNum = 0;
    }

    RowPart(Run run, int posFrom, int posTo, int relRowNum) {
        NullCheck.notNull((Object)run, (String)"run");
        if (posFrom < 0) {
            throw new IllegalArgumentException("posFrom (" + posFrom + ") may not be negative");
        }
        if (posTo < 0) {
            throw new IllegalArgumentException("posTo (" + posTo + ") may not be negative");
        }
        if (posFrom >= posTo) {
            throw new IllegalArgumentException("posFrom (" + posFrom + ") must be less than posTo (" + posTo + ")");
        }
        if (relRowNum < 0) {
            throw new IllegalArgumentException("relRowNum (" + relRowNum + ") may not be negative");
        }
        this.run = run;
        this.posFrom = posFrom;
        this.posTo = posTo;
        this.relRowNum = relRowNum;
    }

    boolean isEmpty() {
        return this.posFrom == this.posTo;
    }

    String getText() {
        if (this.isEmpty()) {
            return "";
        }
        return this.run.text().substring(this.posFrom, this.posTo);
    }

    boolean onTheSameRow(RowPart rowPart) {
        NullCheck.notNull((Object)rowPart, (String)"rowPart");
        if (this.isEmpty() || rowPart.isEmpty()) {
            return false;
        }
        return this.run.getParentNode() == rowPart.run.getParentNode() && this.relRowNum == rowPart.relRowNum;
    }
}

