/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.reader;

import java.util.Arrays;
import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;
import org.luwrain.reader.EmptyLine;
import org.luwrain.reader.Node;
import org.luwrain.reader.TableCell;

public class TableRow
extends Node {
    TableRow() {
        super(Node.Type.TABLE_ROW);
    }

    @Override
    void preprocess() {
        NullCheck.notNullItems((Object[])this.subnodes, (String)"subnodes");
        for (int i = 0; i < this.subnodes.length; ++i) {
            if (this.subnodes[i] instanceof TableCell) continue;
            Log.warning((String)"doctree", (String)("table row has a subnode of class " + this.subnodes[i].getClass().getName() + ", it will be put into newly created table cell"));
            TableCell n = new TableCell();
            n.subnodes = new Node[]{this.subnodes[i]};
            n.subnodes[0].setParentNode(n);
            n.setParentNode(this);
            this.subnodes[i] = n;
        }
        super.preprocess();
    }

    void addEmptyCells(int num) {
        NullCheck.notNullItems((Object[])this.subnodes, (String)"subnodes");
        if (this.subnodes.length >= num) {
            return;
        }
        Node[] newNodes = Arrays.copyOf(this.subnodes, num);
        for (int i = this.subnodes.length; i < newNodes.length; ++i) {
            TableCell cell = new TableCell();
            cell.subnodes = new Node[]{new EmptyLine()};
            cell.subnodes[0].setParentNode(cell);
            cell.setParentNode(this);
            newNodes[i] = cell;
        }
        this.subnodes = newNodes;
    }
}

