/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.reader;

import org.luwrain.core.NullCheck;
import org.luwrain.reader.ListItem;
import org.luwrain.reader.Node;
import org.luwrain.reader.Paragraph;
import org.luwrain.reader.Section;
import org.luwrain.reader.Table;
import org.luwrain.reader.TableCell;
import org.luwrain.reader.TableRow;

public interface Visitor {
    public void visitNode(Node var1);

    public void visit(ListItem var1);

    public void visit(Paragraph var1);

    public void visit(Section var1);

    public void visit(TableCell var1);

    public void visit(Table var1);

    public void visit(TableRow var1);

    public static void walk(Node node, Visitor visitor) {
        NullCheck.notNull((Object)node, (String)"node");
        NullCheck.notNull((Object)visitor, (String)"visitor");
        if (node instanceof ListItem) {
            visitor.visit((ListItem)node);
        } else if (node instanceof Section) {
            visitor.visit((Section)node);
        } else if (node instanceof Table) {
            visitor.visit((Table)node);
        } else if (node instanceof TableRow) {
            visitor.visit((TableRow)node);
        } else if (node instanceof TableCell) {
            visitor.visit((TableCell)node);
        } else if (node instanceof Paragraph) {
            visitor.visit((Paragraph)node);
        } else {
            visitor.visitNode(node);
        }
        if (node.subnodes != null) {
            for (Node n : node.subnodes) {
                Visitor.walk(n, visitor);
            }
        }
    }
}

