/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.reader.view;

import java.util.Arrays;
import org.luwrain.core.Lines;
import org.luwrain.core.NullCheck;
import org.luwrain.reader.Document;
import org.luwrain.reader.Node;
import org.luwrain.reader.Paragraph;
import org.luwrain.reader.view.Row;
import org.luwrain.reader.view.RowPart;

public final class Layout
implements Lines {
    protected final Document document;
    protected final Node root;
    protected final Paragraph[] paragraphs;
    protected final RowPart[] rowParts;
    protected final Row[] rows;
    protected final Line[] lines;

    Layout(Document document, Node root, Row[] rows, RowPart[] rowParts, Paragraph[] paragraphs, int lineCount) {
        NullCheck.notNull((Object)document, (String)"document");
        NullCheck.notNull((Object)root, (String)"root");
        NullCheck.notNullItems((Object[])rows, (String)"rows");
        NullCheck.notNullItems((Object[])rowParts, (String)"rowParts");
        NullCheck.notNullItems((Object[])paragraphs, (String)"paragraphs");
        this.document = document;
        this.root = root;
        this.paragraphs = paragraphs;
        this.rows = rows;
        this.rowParts = rowParts;
        this.lines = new Line[lineCount];
        for (int i = 0; i < this.lines.length; ++i) {
            this.lines[i] = new Line();
        }
        for (Row row : rows) {
            Line line = this.lines[row.y];
            line.add(row);
        }
    }

    public int getLineCount() {
        return this.lines.length;
    }

    public String getLine(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index (" + index + ") may not be negative");
        }
        Line line = this.lines[index];
        StringBuilder b = new StringBuilder();
        for (Row row : line.rows) {
            while (b.length() < row.x) {
                b.append(" ");
            }
            b.append(row.getText());
        }
        return b.toString();
    }

    protected static class Line {
        Row[] rows = new Row[0];

        protected Line() {
        }

        void add(Row row) {
            NullCheck.notNull((Object)row, (String)"row");
            this.rows = Arrays.copyOf(this.rows, this.rows.length + 1);
            this.rows[this.rows.length - 1] = row;
        }
    }
}

