/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.player;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.luwrain.app.player.Task;
import org.luwrain.core.ContentTypes;
import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.core.MediaResourcePlayer;
import org.luwrain.core.NullCheck;
import org.luwrain.player.Listener;
import org.luwrain.player.Player;
import org.luwrain.player.Playlist;

final class Dispatcher
implements Player,
MediaResourcePlayer.Listener {
    static final String LOG_COMPONENT = "player";
    private final Luwrain luwrain;
    private final Random rand = new Random();
    private MediaResourcePlayer[] mediaResourcePlayers;
    private final List<Listener> listeners = new ArrayList<Listener>();
    private Player.State state = Player.State.STOPPED;
    private int volume = 100;
    private MediaResourcePlayer.Instance player = null;
    private Playlist playlist = null;
    private Set<Player.Flags> flags = null;
    private int trackNum = 0;
    private long posMsec = 0L;

    Dispatcher(Luwrain luwrain) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        this.luwrain = luwrain;
        for (MediaResourcePlayer p : this.mediaResourcePlayers = luwrain.getMediaResourcePlayers()) {
            Log.debug((String)LOG_COMPONENT, (String)("'" + p.getExtObjName() + "' is a known media resource player"));
        }
    }

    public synchronized Player.Result play(Playlist playlist, int startingTrackNum, long startingPosMsec, Set<Player.Flags> flags) {
        NullCheck.notNull((Object)playlist, (String)"playlist");
        NullCheck.notNull(flags, (String)"flags");
        if (startingTrackNum < 0 || startingTrackNum >= playlist.getTrackCount()) {
            throw new IllegalArgumentException("Illegal starting track num: " + String.valueOf(startingTrackNum));
        }
        if (startingPosMsec < 0L) {
            throw new IllegalArgumentException("Illegal starting position: " + String.valueOf(startingPosMsec));
        }
        this.stop();
        this.playlist = playlist;
        this.volume = playlist.getVolume();
        this.flags = flags;
        this.trackNum = startingTrackNum;
        this.posMsec = startingPosMsec;
        Player.Result res = this.runPlayer();
        if (res != Player.Result.OK) {
            this.playlist = null;
            this.trackNum = 0;
            this.posMsec = 0L;
            this.flags = null;
            this.state = Player.State.STOPPED;
            return res;
        }
        this.state = Player.State.PLAYING;
        this.notifyListeners(l -> l.onNewState(playlist, Player.State.PLAYING));
        this.notifyListeners(l -> l.onNewPlaylist(playlist));
        this.notifyListeners(l -> l.onNewTrack(playlist, this.trackNum));
        playlist.onProgress(this.trackNum, startingPosMsec);
        return Player.Result.OK;
    }

    public synchronized boolean stop() {
        if (this.state == Player.State.STOPPED) {
            return false;
        }
        if (this.player != null) {
            this.player.stop();
        }
        this.player = null;
        this.trackNum = 0;
        this.posMsec = 0L;
        this.state = Player.State.STOPPED;
        this.notifyListeners(listener -> listener.onNewState(this.playlist, Player.State.STOPPED));
        return true;
    }

    public synchronized boolean pauseResume() {
        if (this.state == Player.State.STOPPED) {
            return false;
        }
        if (this.state == Player.State.PLAYING) {
            this.player.stop();
            this.player = null;
            this.state = Player.State.PAUSED;
            this.notifyListeners(listener -> listener.onNewState(this.playlist, Player.State.PAUSED));
        } else {
            if (this.runPlayer() != Player.Result.OK) {
                return true;
            }
            this.state = Player.State.PLAYING;
            this.notifyListeners(listener -> listener.onNewState(this.playlist, Player.State.PLAYING));
            this.notifyListeners(listener -> listener.onTrackTime(this.playlist, this.trackNum, this.posMsec));
        }
        return true;
    }

    public synchronized boolean jump(long offsetMsec) {
        if (this.state == Player.State.STOPPED || this.flags.contains(Player.Flags.STREAMING)) {
            return false;
        }
        if (this.player != null) {
            this.player.stop();
            this.player = null;
        }
        this.posMsec += offsetMsec;
        if (this.posMsec < 0L) {
            this.posMsec = 0L;
        }
        this.runPlayer();
        this.state = Player.State.PLAYING;
        this.notifyListeners(listener -> listener.onTrackTime(this.playlist, this.trackNum, this.posMsec));
        this.playlist.onProgress(this.trackNum, this.posMsec);
        return true;
    }

    public synchronized boolean nextTrack() {
        if (this.state == Player.State.STOPPED || this.flags.contains(Player.Flags.STREAMING)) {
            return false;
        }
        if (this.trackNum + 1 >= this.playlist.getTrackCount()) {
            return false;
        }
        Player.State prevState = this.state;
        if (this.player != null) {
            this.player.stop();
            this.player = null;
        }
        ++this.trackNum;
        this.posMsec = 0L;
        this.runPlayer();
        this.state = Player.State.PLAYING;
        if (prevState != this.state) {
            this.notifyListeners(listener -> listener.onNewState(this.playlist, Player.State.PLAYING));
        }
        this.notifyListeners(listener -> listener.onNewTrack(this.playlist, this.trackNum));
        this.notifyListeners(listener -> listener.onTrackTime(this.playlist, this.trackNum, 0L));
        this.playlist.onProgress(this.trackNum, 0L);
        return true;
    }

    public synchronized boolean prevTrack() {
        if (this.state == Player.State.STOPPED || this.flags.contains(Player.Flags.STREAMING)) {
            return false;
        }
        if (this.trackNum == 0) {
            return false;
        }
        Player.State prevState = this.state;
        if (this.player != null) {
            this.player.stop();
            this.player = null;
        }
        --this.trackNum;
        this.posMsec = 0L;
        this.runPlayer();
        this.state = Player.State.PLAYING;
        if (prevState != this.state) {
            this.notifyListeners(listener -> listener.onNewState(this.playlist, Player.State.PLAYING));
        }
        this.notifyListeners(listener -> listener.onNewTrack(this.playlist, this.trackNum));
        this.notifyListeners(listener -> listener.onTrackTime(this.playlist, this.trackNum, 0L));
        this.playlist.onProgress(this.trackNum, 0L);
        return true;
    }

    public synchronized boolean playTrack(int trackIndex) {
        if (this.state == Player.State.STOPPED || this.flags.contains(Player.Flags.STREAMING)) {
            return false;
        }
        if (trackIndex < 0 || trackIndex >= this.playlist.getTrackCount()) {
            return false;
        }
        Player.State prevState = this.state;
        if (this.player != null) {
            this.player.stop();
            this.player = null;
        }
        this.trackNum = trackIndex;
        this.posMsec = 0L;
        this.runPlayer();
        this.state = Player.State.PLAYING;
        if (prevState != this.state) {
            this.notifyListeners(listener -> listener.onNewState(this.playlist, Player.State.PLAYING));
        }
        this.notifyListeners(listener -> listener.onNewTrack(this.playlist, this.trackNum));
        this.notifyListeners(listener -> listener.onTrackTime(this.playlist, this.trackNum, 0L));
        this.playlist.onProgress(this.trackNum, 0L);
        return true;
    }

    public synchronized void onPlayerTime(MediaResourcePlayer.Instance sourcePlayer, long msec) {
        if (this.player == null || sourcePlayer == null || this.player != sourcePlayer) {
            return;
        }
        if (this.state != Player.State.PLAYING || this.flags.contains(Player.Flags.STREAMING)) {
            return;
        }
        if (this.posMsec <= msec && msec < this.posMsec + 50L) {
            return;
        }
        this.posMsec = msec;
        this.notifyListeners(listener -> listener.onTrackTime(this.playlist, this.trackNum, this.posMsec));
        this.playlist.onProgress(this.trackNum, this.posMsec);
    }

    public synchronized void onPlayerFinish(MediaResourcePlayer.Instance sourcePlayer) {
        if (this.player == null || sourcePlayer == null || this.player != sourcePlayer) {
            return;
        }
        if (this.state != Player.State.PLAYING) {
            return;
        }
        if (this.flags.contains(Player.Flags.STREAMING)) {
            this.stop();
            return;
        }
        if (!this.flags.contains(Player.Flags.CYCLED) && !this.flags.contains(Player.Flags.RANDOM)) {
            if (this.trackNum + 1 < this.playlist.getTrackCount()) {
                this.nextTrack();
            } else {
                this.stop();
            }
            return;
        }
        if (this.player != null) {
            this.player.stop();
            this.player = null;
        }
        this.trackNum = !this.flags.contains(Player.Flags.RANDOM) ? (this.trackNum + 1 < this.playlist.getTrackCount() ? ++this.trackNum : 0) : this.rand.nextInt(this.playlist.getTrackCount());
        this.posMsec = 0L;
        this.runPlayer();
        this.state = Player.State.PLAYING;
        this.notifyListeners(listener -> listener.onNewTrack(this.playlist, this.trackNum));
        this.notifyListeners(listener -> listener.onTrackTime(this.playlist, this.trackNum, 0L));
        this.playlist.onProgress(this.trackNum, 0L);
    }

    public synchronized void onPlayerError(Exception e) {
    }

    public synchronized boolean hasPlaylist() {
        return this.playlist != null;
    }

    public synchronized Playlist getPlaylist() {
        return this.playlist;
    }

    public synchronized int getTrackNum() {
        return this.trackNum;
    }

    public Player.State getState() {
        return this.state != null ? this.state : Player.State.STOPPED;
    }

    public int getVolume() {
        return this.volume;
    }

    public void setVolume(int value) {
        int newVolume = Math.min(Math.max(value, 0), 100);
        if (this.volume == newVolume) {
            return;
        }
        this.volume = newVolume;
        if (this.player != null) {
            this.player.setVolume(this.volume);
        }
        if (this.playlist != null) {
            this.playlist.onNewVolume(this.volume);
        }
    }

    public Set<Player.Flags> getFlags() {
        return this.flags;
    }

    public synchronized void addListener(Listener listener) {
        NullCheck.notNull((Object)listener, (String)"listener");
        for (Listener l : this.listeners) {
            if (l != listener) continue;
            return;
        }
        this.listeners.add(listener);
    }

    public synchronized void removeListener(Listener listener) {
        NullCheck.notNull((Object)listener, (String)"listener");
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (this.listeners.get(i) != listener) continue;
            this.listeners.remove(i);
            break;
        }
    }

    private void notifyListeners(ListenerNotification notification) {
        for (Listener l : this.listeners) {
            try {
                notification.notify(l);
            }
            catch (Throwable e) {
                Log.warning((String)LOG_COMPONENT, (String)("a player listener has thrown an exception: " + e.getClass().getName() + ": " + e.getMessage()));
            }
        }
    }

    private Task createTask() {
        if (this.trackNum >= this.playlist.getTrackCount()) {
            return null;
        }
        String url = this.playlist.getTrackUrl(this.trackNum);
        try {
            return new Task(new URL(url), this.flags.contains(Player.Flags.STREAMING) ? 0L : this.posMsec);
        }
        catch (IOException e) {
            Log.error((String)LOG_COMPONENT, (String)("unable to create the URL object for " + url + ":" + e.getClass().getName() + ":" + e.getMessage()));
            return null;
        }
    }

    private MediaResourcePlayer findPlayer(Task task) {
        NullCheck.notNull((Object)task, (String)"task");
        String contentType = this.luwrain.suggestContentType(task.url, ContentTypes.ExpectedType.AUDIO);
        for (MediaResourcePlayer p : this.mediaResourcePlayers) {
            String supportedTypes = p.getSupportedMimeType();
            if (!supportedTypes.trim().toLowerCase().equals(contentType.trim().toLowerCase())) continue;
            return p;
        }
        return null;
    }

    private Player.Result runPlayer() {
        Task task = this.createTask();
        if (task == null) {
            return Player.Result.INVALID_PLAYLIST;
        }
        MediaResourcePlayer p = this.findPlayer(task);
        if (p == null) {
            Log.error((String)LOG_COMPONENT, (String)("unable to choose a player for " + task.url.toString()));
            return Player.Result.UNSUPPORTED_FORMAT_STARTING_TRACK;
        }
        MediaResourcePlayer.Instance instance = p.newMediaResourcePlayer((MediaResourcePlayer.Listener)this);
        MediaResourcePlayer.Params params = new MediaResourcePlayer.Params();
        params.playFromMsec = task.startPosMsec;
        params.volume = this.volume;
        params.flags = EnumSet.noneOf(MediaResourcePlayer.Flags.class);
        MediaResourcePlayer.Result result = instance.play(task.url, params);
        if (result == null) {
            return Player.Result.GENERAL_PLAYER_ERROR;
        }
        if (!result.isOk()) {
            switch (result.getType()) {
                case INACCESSIBLE_SOURCE: {
                    return Player.Result.INACCESSIBLE_SOURCE;
                }
            }
            return Player.Result.GENERAL_PLAYER_ERROR;
        }
        this.player = instance;
        return Player.Result.OK;
    }

    private static interface ListenerNotification {
        public void notify(Listener var1);
    }
}

