/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.player;

import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.player.Album;
import org.luwrain.app.player.App;
import org.luwrain.app.player.ControlArea;
import org.luwrain.app.player.Strings;
import org.luwrain.app.player.Track;
import org.luwrain.app.player.Utils;
import org.luwrain.app.player.layouts.DirAlbumPropertiesLayout;
import org.luwrain.app.player.layouts.StreamAlbumPropertiesLayout;
import org.luwrain.controls.EditableListArea;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.player.Player;
import org.luwrain.player.Playlist;

final class MainLayout
extends LayoutBase {
    static final int STEP_VOLUME = 5;
    static final int STEP_JUMP = 5000;
    private static final InputEvent KEY_PAUSE_RESUME = new InputEvent(' ');
    private static final InputEvent KEY_NEXT_TRACK = new InputEvent('=', EnumSet.of(InputEvent.Modifiers.ALT));
    private static final InputEvent KEY_PREV_TRACK = new InputEvent('-', EnumSet.of(InputEvent.Modifiers.ALT));
    private static final InputEvent KEY_VOLUME_PLUS = new InputEvent('+', EnumSet.of(InputEvent.Modifiers.SHIFT));
    private static final InputEvent KEY_VOLUME_MINUS = new InputEvent('_', EnumSet.of(InputEvent.Modifiers.SHIFT));
    private static final InputEvent KEY_JUMP_FORWARD = new InputEvent('=');
    private static final InputEvent KEY_JUMP_BACKWARD = new InputEvent('-');
    private final App app;
    private final Player player;
    final EditableListArea<Album> albumsArea;
    final ListArea<Track> playlistArea;
    final ControlArea controlArea;
    private Track[] tracks = new Track[0];

    MainLayout(App app, Player player) {
        super((AppBase)app);
        this.app = app;
        this.player = player;
        LayoutBase.ActionInfo actionPauseResume = this.action("pause-resume", ((Strings)app.getStrings()).actionPauseResume(), KEY_PAUSE_RESUME, () -> ((Player)app.getPlayer()).pauseResume());
        LayoutBase.ActionInfo actionNextTrack = this.action("next-track", ((Strings)app.getStrings()).actionNextTrack(), KEY_NEXT_TRACK, () -> this.actTrack(1));
        LayoutBase.ActionInfo actionPrevTrack = this.action("prev-track", ((Strings)app.getStrings()).actionPrevTrack(), KEY_PREV_TRACK, () -> this.actTrack(-1));
        LayoutBase.ActionInfo actionVolumePlus = this.action("volume-plus", ((Strings)app.getStrings()).actionVolumePlus(), KEY_VOLUME_PLUS, () -> this.actVolume(5));
        LayoutBase.ActionInfo actionVolumeMinus = this.action("volume-minus", ((Strings)app.getStrings()).actionVolumeMinus(), KEY_VOLUME_MINUS, () -> this.actVolume(-5));
        LayoutBase.ActionInfo actionJumpForward = this.action("jump-forward", ((Strings)app.getStrings()).actionJumpForward(), KEY_JUMP_FORWARD, () -> app.getPlayer().jump(5000L));
        LayoutBase.ActionInfo actionJumpBackward = this.action("jump-backward", ((Strings)app.getStrings()).actionJumpBackward(), KEY_JUMP_BACKWARD, () -> app.getPlayer().jump(-5000L));
        EditableListArea.Params params2 = new EditableListArea.Params();
        params2.context = this.getControlContext();
        params2.model = app.getAlbums();
        params2.name = ((Strings)app.getStrings()).albumsAreaName();
        params2.clickHandler = (area, index, obj) -> app.starting.play((Album)obj);
        params2.appearance = new ListUtils.DoubleLevelAppearance<Album>(params2.context){

            public boolean isSectionItem(Album album) {
                return MainLayout.this.isSectionItem(album);
            }
        };
        params2.transition = new ListUtils.DoubleLevelTransition<Album>(params2.model){

            public boolean isSectionItem(Album album) {
                return MainLayout.this.isSectionItem(album);
            }
        };
        params2.clipboardSaver = (area, model, appearance, fromIndex, toIndex, clipboard) -> {
            ArrayList<Album> a = new ArrayList<Album>();
            ArrayList<String> s = new ArrayList<String>();
            for (int i = fromIndex; i < toIndex; ++i) {
                Album album = (Album)model.getItem(i);
                a.add(album);
                String text = appearance.getScreenAppearance((Object)album, EnumSet.noneOf(ListArea.Appearance.Flags.class));
                s.add(text.substring(appearance.getObservableLeftBound((Object)album), appearance.getObservableRightBound((Object)album)));
            }
            clipboard.set((Object[])a.toArray(new Album[a.size()]), s.toArray(new String[s.size()]));
            return true;
        };
        this.albumsArea = new EditableListArea<Album>(params2){

            public boolean onSystemEvent(SystemEvent event) {
                if (event.getType() == SystemEvent.Type.REGULAR) {
                    switch (event.getCode()) {
                        case PROPERTIES: {
                            return MainLayout.this.onAlbumProperties();
                        }
                    }
                }
                return super.onSystemEvent(event);
            }
        };
        LayoutBase.Actions albumsActions = this.actions(new LayoutBase.ActionInfo[]{this.action("add-album", ((Strings)app.getStrings()).actionAddAlbum(), new InputEvent(InputEvent.Special.INSERT), this::actAddAlbum), actionPauseResume, actionNextTrack, actionPrevTrack, actionJumpForward, actionJumpBackward, actionVolumePlus, actionVolumeMinus});
        this.playlistArea = new ListArea(this.listParams(params -> {
            params.name = ((Strings)app.getStrings()).playlistAreaName();
            params.model = new ListUtils.ArrayModel(() -> this.tracks);
            params.clickHandler = (area, index, track) -> {
                Playlist playlist = app.getPlayer().getPlaylist();
                if (playlist == null) {
                    return false;
                }
                if (index >= playlist.getTrackCount()) {
                    return false;
                }
                app.getPlayer().playTrack(index);
                return true;
            };
        }));
        LayoutBase.Actions playlistActions = this.actions(new LayoutBase.ActionInfo[]{actionPauseResume, actionNextTrack, actionPrevTrack, actionJumpForward, actionJumpBackward, actionVolumePlus, actionVolumeMinus});
        this.controlArea = new ControlArea(app, this.getControlContext(), (Strings)app.getStrings());
        LayoutBase.Actions controlActions = this.actions(new LayoutBase.ActionInfo[]{actionPauseResume, actionNextTrack, actionPrevTrack, actionJumpForward, actionJumpBackward, actionVolumePlus, actionVolumeMinus});
        this.setAreaLayout(AreaLayout.LEFT_TOP_BOTTOM, (Area)this.albumsArea, albumsActions, (Area)this.playlistArea, playlistActions, (Area)this.controlArea, controlActions);
    }

    private boolean actAddAlbum() {
        Album.Type type = this.app.getConv().newAlbumType();
        if (type == null) {
            return true;
        }
        if (type == Album.Type.SECTION) {
            Album album = new Album();
            album.setType(Album.Type.SECTION);
            String title = this.app.getConv().newSectionTitle();
            if (title == null) {
                return true;
            }
            album.setTitle(title);
            int index = this.app.getAlbums().addAlbum(this.albumsArea.selectedIndex(), album);
            this.albumsArea.refresh();
            this.albumsArea.select(index, false);
            return true;
        }
        String title = this.app.getConv().newAlbumTitle();
        if (title == null) {
            return true;
        }
        Album album = new Album();
        album.setType(type);
        album.setTitle(title);
        switch (type) {
            case STREAMING: {
                String url = this.app.getConv().newStreamingAlbumUrl();
                if (url == null) {
                    return true;
                }
                album.setUrl(url);
                break;
            }
            case DIR: {
                File path = this.app.getConv().dirAlbumPath();
                if (path == null) {
                    return true;
                }
                album.setPath(path.getAbsolutePath());
                break;
            }
            default: {
                return true;
            }
        }
        int index = this.app.getAlbums().addAlbum(this.albumsArea.selectedIndex(), album);
        this.albumsArea.refresh();
        this.albumsArea.select(index, false);
        return true;
    }

    private boolean actTrack(int pos) {
        Playlist playlist = this.app.getPlayer().getPlaylist();
        if (playlist == null) {
            return false;
        }
        int index = this.app.getPlayer().getTrackNum();
        if (index < 0 || index >= playlist.getTrackCount()) {
            return false;
        }
        if ((index += pos) < 0 || index >= playlist.getTrackCount()) {
            return false;
        }
        return this.app.getPlayer().playTrack(index);
    }

    private boolean actVolume(int step) {
        int level = this.app.getPlayer().getVolume() + step;
        if (level < 0 || level > 100) {
            return false;
        }
        this.app.getPlayer().setVolume(level);
        return true;
    }

    void onNewPlaylist(Playlist playlist) {
        this.tracks = new Track[playlist.getTrackCount()];
        for (int i = 0; i < this.tracks.length; ++i) {
            this.tracks[i] = new Track(playlist.getTrackUrl(i), this.app.trackInfoMap);
        }
        this.app.fillTrackInfoMap(playlist, this.playlistArea);
        this.playlistArea.reset(false);
        this.playlistArea.refresh();
    }

    private boolean onAlbumProperties() {
        LayoutBase layout;
        Album album = (Album)this.albumsArea.selected();
        if (album == null) {
            return false;
        }
        LayoutBase.ActionHandler closing = () -> {
            this.app.getAlbums().save();
            this.app.setAreaLayout(this);
            this.setActiveArea((Area)this.albumsArea);
            return true;
        };
        switch (album.getType()) {
            case STREAMING: {
                layout = new StreamAlbumPropertiesLayout(this.app, album, closing);
                break;
            }
            case DIR: {
                layout = new DirAlbumPropertiesLayout(this.app, album, closing);
                break;
            }
            default: {
                return false;
            }
        }
        this.app.setAreaLayout(layout);
        this.getLuwrain().announceActiveArea();
        return true;
    }

    private String getTrackTextAppearance(String trackUrl) {
        return Utils.getTrackTextAppearanceWithMap(trackUrl, this.app.trackInfoMap);
    }

    boolean isSectionItem(Object item) {
        if (item instanceof Album) {
            Album album = (Album)item;
            return album.isSection();
        }
        return false;
    }
}

