/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.player.layouts;

import java.io.File;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.player.Album;
import org.luwrain.app.player.App;
import org.luwrain.app.player.Strings;
import org.luwrain.controls.FormArea;
import org.luwrain.core.Area;
import org.luwrain.core.Luwrain;
import org.luwrain.core.events.InputEvent;

public final class DirAlbumPropertiesLayout
extends LayoutBase {
    private static final String TITLE = "title";
    private static final String PATH = "path";
    private static final String SAVE_POSITION = "save-pos";
    private final App app;
    private final FormArea formArea;

    public DirAlbumPropertiesLayout(final App app, Album album, LayoutBase.ActionHandler closing) {
        super((AppBase)app);
        this.app = app;
        this.formArea = new FormArea(this.getControlContext(), album.getTitle()){

            public boolean onInputEvent(InputEvent event) {
                if (event.isSpecial() && !event.isModified()) {
                    switch (event.getSpecial()) {
                        case ENTER: {
                            if (this.getHotPointY() != 1) break;
                            File path = app.getConv().dirAlbumPath();
                            if (path == null) {
                                return true;
                            }
                            DirAlbumPropertiesLayout.this.formArea.setEnteredText(DirAlbumPropertiesLayout.PATH, path.getAbsolutePath());
                        }
                    }
                }
                return super.onInputEvent(event);
            }
        };
        this.formArea.addEdit(TITLE, ((Strings)app.getStrings()).albumPropTitle(), album.getTitle());
        this.formArea.addEdit(PATH, ((Strings)app.getStrings()).albumPropPath(), album.getPath());
        this.formArea.addCheckbox(SAVE_POSITION, ((Strings)app.getStrings()).albumPropSavePosition(), album.isSavePosition());
        this.setCloseHandler(closing);
        this.setOkHandler(() -> this.onOk(album, closing));
        this.setAreaLayout((Area)this.formArea, null);
    }

    private boolean onOk(Album album, LayoutBase.ActionHandler closing) {
        String title = this.formArea.getEnteredText(TITLE);
        String path = this.formArea.getEnteredText(PATH);
        if (title.trim().isEmpty()) {
            this.app.message(((Strings)this.app.getStrings()).albumPropTitleCannotBeEmpty(), Luwrain.MessageType.ERROR);
            return true;
        }
        album.setTitle(title.trim());
        album.setPath(path);
        album.setSavePosition(this.formArea.getCheckboxState(SAVE_POSITION));
        closing.onAction();
        return true;
    }
}

