/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.player.layouts;

import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.player.Album;
import org.luwrain.app.player.App;
import org.luwrain.app.player.Strings;
import org.luwrain.controls.FormArea;
import org.luwrain.core.Area;
import org.luwrain.core.Luwrain;

public final class StreamAlbumPropertiesLayout
extends LayoutBase {
    private static final String TITLE = "title";
    private static final String URL = "url";
    private final App app;
    private final FormArea formArea;

    public StreamAlbumPropertiesLayout(App app, Album album, LayoutBase.ActionHandler closing) {
        super((AppBase)app);
        this.app = app;
        this.formArea = new FormArea(this.getControlContext(), album.getTitle());
        this.formArea.addEdit(TITLE, ((Strings)app.getStrings()).albumPropTitle(), album.getTitle());
        this.formArea.addEdit(URL, ((Strings)app.getStrings()).albumPropUrl(), album.getUrl());
        this.setCloseHandler(closing);
        this.setOkHandler(() -> this.onOk(album, closing));
        this.setAreaLayout((Area)this.formArea, null);
    }

    private boolean onOk(Album album, LayoutBase.ActionHandler closing) {
        String title = this.formArea.getEnteredText(TITLE);
        String url = this.formArea.getEnteredText(URL);
        if (title.trim().isEmpty()) {
            this.app.message(((Strings)this.app.getStrings()).albumPropTitleCannotBeEmpty(), Luwrain.MessageType.ERROR);
            return true;
        }
        album.setTitle(title.trim());
        album.setUrl(url.trim());
        closing.onAction();
        return true;
    }
}

