/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.term;

import com.pty4j.PtyProcessBuilder;
import com.pty4j.unix.UnixPtyProcess;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.FutureTask;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.term.MainLayout;
import org.luwrain.app.term.Strings;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;
import org.luwrain.linux.TermInfo;

public final class App
extends AppBase<Strings> {
    static final String LOG_COMPONENT = "term";
    private static final long LISTENING_DELAY = 10L;
    final TermInfo termInfo;
    final String startingDir;
    private UnixPtyProcess pty = null;
    private MainLayout layout = null;
    private volatile StringBuilder termOutput = new StringBuilder();
    private volatile long latestOutputTimestamp = new Date().getTime();

    public App(TermInfo termInfo) {
        super("luwrain.term", Strings.class, "luwrain.linux.term");
        NullCheck.notNull((Object)termInfo, (String)"termInfo");
        this.termInfo = termInfo;
        this.startingDir = null;
    }

    public App(TermInfo termInfo, String startingDir) {
        super("luwrain.term", Strings.class, "luwrain.linux.term");
        NullCheck.notNull((Object)termInfo, (String)"termInfo");
        this.termInfo = termInfo;
        this.startingDir = startingDir;
    }

    public AreaLayout onAppInit() throws IOException {
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        env.put("TERM", "linux");
        this.pty = (UnixPtyProcess)new PtyProcessBuilder(new String[]{"/bin/bash", "-l"}).setEnvironment(env).setDirectory(this.startingDir != null && !this.startingDir.isEmpty() ? this.startingDir : this.getLuwrain().getProperty("luwrain.dir.userhome")).setConsole(false).start();
        this.getLuwrain().executeBkg(new FutureTask<Object>(() -> this.readOutput(), null));
        this.getLuwrain().executeBkg(new FutureTask<Object>(() -> this.listening(), null));
        this.setAppName(((Strings)this.getStrings()).appName());
        this.layout = new MainLayout(this);
        return this.layout.getLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readOutput() {
        try {
            try {
                InputStream is = this.pty.getInputStream();
                InputStreamReader r = new InputStreamReader(is, "UTF-8");
                while (this.pty.isRunning()) {
                    int c = r.read();
                    if (c < 0) {
                        Log.debug((String)LOG_COMPONENT, (String)("negative character from the terminal: " + c));
                        break;
                    }
                    App app = this;
                    synchronized (app) {
                        this.termOutput.append((char)c);
                        this.latestOutputTimestamp = new Date().getTime();
                    }
                }
                Log.debug((String)LOG_COMPONENT, (String)"closing the terminal");
                r.close();
                is.close();
                try {
                    this.pty.waitFor();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                Log.debug((String)LOG_COMPONENT, (String)("exit value is " + this.pty.exitValue()));
            }
            catch (Exception e) {
                this.crash(e);
            }
        }
        catch (Throwable t) {
            Log.error((String)LOG_COMPONENT, (String)("pty: " + t.getClass().getName() + ":" + t.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listening() {
        try {
            while (this.pty.isRunning()) {
                String output;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                App app = this;
                synchronized (app) {
                    if (this.termOutput.length() == 0) {
                        continue;
                    }
                    long timestamp = new Date().getTime();
                    if (timestamp - this.latestOutputTimestamp < 10L) {
                        continue;
                    }
                    output = new String(this.termOutput);
                    this.termOutput = new StringBuilder();
                }
                this.getLuwrain().runUiSafely(() -> {
                    if (this.layout != null) {
                        this.layout.termText(output);
                    }
                });
            }
        }
        finally {
            Log.debug((String)LOG_COMPONENT, (String)("finishing listening thread, running=" + this.pty.isRunning()));
            App app = this;
            synchronized (app) {
                String output = new String(this.termOutput);
                this.termOutput = new StringBuilder();
                if (!output.isEmpty()) {
                    this.getLuwrain().runUiSafely(() -> {
                        if (this.layout != null) {
                            this.layout.termText(output);
                        }
                    });
                }
            }
        }
    }

    void sendChar(char ch) {
        try {
            if (ch < ' ') {
                this.pty.getOutputStream().write((byte)ch);
                return;
            }
            OutputStreamWriter w = new OutputStreamWriter(this.pty.getOutputStream(), "UTF-8");
            w.write(ch);
            w.flush();
        }
        catch (IOException e) {
            this.getLuwrain().crash((Throwable)e);
        }
    }

    public void closeApp() {
        this.pty.hangup();
        this.pty.destroy();
        super.closeApp();
    }
}

