/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.linux;

import java.io.IOException;
import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.luwrain.core.NullCheck;
import org.luwrain.linux.BashProcess;
import org.luwrain.linux.BlockDevices;

public final class Parted {
    public static final String GPT = "gpt";
    public static final String NVME = "nvme";
    public static final String SCSI = "scsi";
    private static final Pattern PAT_DEVICE = Pattern.compile("^(/[^:]*):([^:]*):([^:]*):([^:]*):([^:]*):([^:]*):([^:]*):.*;$", 2);
    private final String device;
    private final Caller caller;
    private String size = "";
    private String type = "";
    private String partTableType = "";
    private String name = "";

    public Parted(String device, Caller caller) {
        NullCheck.notEmpty((Object)device, (String)"device");
        NullCheck.notNull((Object)caller, (String)"caller");
        this.device = device;
        this.caller = caller;
    }

    public Parted(String device) {
        this(device, Parted.createDefaultCaller());
    }

    public void init() throws IOException {
        String[] lines;
        for (String line : lines = this.caller.call(new String[]{this.device, "print"})) {
            Matcher m = PAT_DEVICE.matcher(line.trim());
            if (!m.find()) continue;
            this.size = m.group(2);
            this.type = m.group(3);
            this.partTableType = m.group(6);
            this.name = m.group(7);
        }
    }

    public String toString() {
        String devStr = BlockDevices.DEV.getPath();
        StringBuilder b = new StringBuilder();
        if (this.device.startsWith(devStr)) {
            b.append(this.device.substring(devStr.length()));
        } else {
            b.append(this.device);
        }
        if (this.size != null && !this.size.trim().isEmpty()) {
            b.append(", ").append(this.size.trim());
        }
        if (this.name != null && !this.name.trim().isEmpty()) {
            b.append(", ").append(this.name.trim());
        }
        return new String(b);
    }

    public String getSize() {
        return this.size;
    }

    public String getType() {
        return this.type;
    }

    public String getPartTableType() {
        return this.partTableType;
    }

    public String getName() {
        return this.name;
    }

    public static Caller createDefaultCaller() {
        return args -> {
            StringBuilder cmd = new StringBuilder();
            cmd.append("parted -m");
            if (args != null) {
                for (String a : args) {
                    cmd.append(" ").append(BashProcess.escape(a));
                }
            }
            BashProcess p = new BashProcess(new String(cmd), EnumSet.of(BashProcess.Flags.ROOT));
            p.run();
            int exitCode = p.waitFor();
            if (exitCode != 0) {
                throw new IOException("nmcli returned " + String.valueOf(exitCode));
            }
            return p.getOutput();
        };
    }

    public static interface Caller {
        public String[] call(String[] var1) throws IOException;
    }
}

