/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.linux;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;
import org.luwrain.core.PropertiesBase;
import org.luwrain.linux.PciIds;
import org.luwrain.linux.SysDevice;
import org.luwrain.util.FileUtils;

public final class SysDevicesList {
    private static final String LOG_COMPONENT = "linux";
    private final PropertiesBase props;
    private final PciIds pciIds = new PciIds();
    private final File sysBlockDir;
    private final File pciDevDir;

    public SysDevicesList(PropertiesBase props) {
        NullCheck.notNull((Object)props, (String)"props");
        this.props = props;
        File pciidsFile = props.getFileProperty("luwrain.linux.pciids");
        if (pciidsFile != null) {
            this.pciIds.load(pciidsFile);
        }
        this.sysBlockDir = props.getFileProperty("luwrain.linux.sysblockdir");
        if (this.sysBlockDir == null) {
            Log.warning((String)LOG_COMPONENT, (String)"no 'luwrain.linux.sysblockdir' property");
        }
        this.pciDevDir = props.getFileProperty("luwrain.linux.pcidevdir");
        if (this.pciDevDir == null) {
            Log.warning((String)LOG_COMPONENT, (String)"no 'luwrain.linux.pcidevdir' property");
        }
    }

    public SysDevice[] getSysDevices() {
        if (this.pciDevDir == null) {
            return new SysDevice[0];
        }
        ArrayList<SysDevice> devices = new ArrayList<SysDevice>();
        File[] pciDirs = this.pciDevDir.listFiles();
        if (pciDirs == null) {
            return new SysDevice[0];
        }
        for (File d : pciDirs) {
            String res;
            String res2;
            String res3;
            String classStr = SysDevicesList.readTextFile(new File(d, "class").getAbsolutePath());
            String vendorStr = SysDevicesList.readTextFile(new File(d, "vendor").getAbsolutePath());
            String modelStr = SysDevicesList.readTextFile(new File(d, "device").getAbsolutePath());
            SysDevice.Type type = SysDevice.Type.PCI;
            String name = d.getName();
            String cls = classStr != null && classStr.startsWith("0x") ? ((res3 = this.pciIds.findClass(classStr.substring(2))) != null && !res3.isEmpty() ? res3 : classStr) : classStr;
            String vendor = vendorStr != null && vendorStr.startsWith("0x") ? ((res2 = this.pciIds.findVendor(vendorStr.substring(2))) != null && !res2.isEmpty() ? res2 : vendorStr) : vendorStr;
            String model = vendorStr != null && vendorStr.startsWith("0x") && modelStr != null && modelStr.startsWith("0x") ? ((res = this.pciIds.findDevice(vendorStr.substring(2), modelStr.substring(2))) != null && !res.isEmpty() ? res : modelStr) : modelStr;
            devices.add(new SysDevice(type, name, cls, vendor, model, "", ""));
        }
        return devices.toArray(new SysDevice[devices.size()]);
    }

    private static String readTextFile(String fileName) {
        try {
            String text = FileUtils.readTextFileSingleString((File)new File(fileName), (String)"UTF-8");
            return text.replaceAll("\n", "");
        }
        catch (IOException e) {
            Log.error((String)LOG_COMPONENT, (String)("unable to read " + fileName + ":" + e.getClass().getName() + ":" + e.getMessage()));
            return "";
        }
    }
}

