/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.linux.script;

import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyArray;
import org.graalvm.polyglot.proxy.ProxyObject;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.linux.BashProcess;
import org.luwrain.linux.script.BashProcessObj;
import org.luwrain.script.ScriptUtils;
import org.luwrain.script.core.ScriptException;

final class LinuxObj
implements ProxyObject {
    private static String[] KEYS = new String[]{"run", "runAsync"};
    private static final Set<String> KEYS_SET = new HashSet<String>(Arrays.asList(KEYS));
    private static final ProxyArray KEYS_ARRAY = ProxyArray.fromArray((Object[])KEYS);
    final Luwrain luwrain;
    final Object syncObj;

    LinuxObj(Luwrain luwrain, Object syncObj) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull((Object)syncObj, (String)"syncObj");
        this.luwrain = luwrain;
        this.syncObj = syncObj;
    }

    public Object getMember(String name) {
        if (name == null) {
            return null;
        }
        switch (name) {
            case "run": {
                return this::run;
            }
            case "runAsync": {
                return this::runAsync;
            }
        }
        return null;
    }

    public boolean hasMember(String name) {
        return KEYS_SET.contains(name);
    }

    public Object getMemberKeys() {
        return KEYS_ARRAY;
    }

    public void putMember(String name, Value value) {
        throw new RuntimeException("The Linux object doesn't support updating of its variables");
    }

    private Object run(Value[] args) {
        if (!ScriptUtils.notNullAndLen((Value[])args, (int)1)) {
            throw new ScriptException("Linux.run() takes exactly one argument with the command line to run");
        }
        String command = ScriptUtils.asString((Object)args[0]);
        if (command == null) {
            throw new ScriptException("Linux.run() takes a not null string as its first argument");
        }
        BashProcess p = new BashProcess(command);
        try {
            p.run();
        }
        catch (IOException e) {
            throw new ScriptException((Throwable)e);
        }
        p.waitFor();
        return new BashProcessObj(p);
    }

    private Object runAsync(Value[] args) {
        Value error;
        Value output;
        if (!ScriptUtils.notNull((Value[])args)) {
            throw new ScriptException("Linux.runAsync() doesn't take null in arguments");
        }
        if (args.length < 1 || args.length > 3) {
            throw new ScriptException("Linux.runAsync() takes 1, 2 or 3 arguments");
        }
        if (!args[0].isString()) {
            throw new ScriptException("Linux.runAsync() takes a string as its first argument");
        }
        String cmd = args[0].asString();
        if (args.length >= 2) {
            if (!args[1].canExecute()) {
                throw new ScriptException("Linux.runAsync() takes a function as its second argument");
            }
            output = args[1];
        } else {
            output = null;
        }
        if (args.length == 3) {
            if (!args[2].canExecute()) {
                throw new ScriptException("Linux.runAsync() takes a function as its third argument");
            }
            error = args[2];
        } else {
            error = null;
        }
        BashProcess.Listener listener = new BashProcess.Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onOutputLine(String line) {
                if (output == null) {
                    return;
                }
                Object object = LinuxObj.this.syncObj;
                synchronized (object) {
                    output.execute(new Object[]{line});
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onErrorLine(String line) {
                if (error == null) {
                    return;
                }
                Object object = LinuxObj.this.syncObj;
                synchronized (object) {
                    error.execute(new Object[]{line});
                }
            }

            @Override
            public void onFinishing(int exitCode) {
            }
        };
        BashProcess p = new BashProcess(cmd, null, EnumSet.noneOf(BashProcess.Flags.class), listener);
        try {
            p.run();
        }
        catch (IOException e) {
            throw new ScriptException((Throwable)e);
        }
        return new BashProcessObj(p);
    }
}

