/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.linux.services;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;
import org.luwrain.linux.BashProcess;

public final class UdisksCli {
    private static final String LOG_COMPONENT = "udisks";
    private static final Pattern PAT_MOUNTED = Pattern.compile("^\\s*Mounted\\s+[^ ]+\\s+at\\s+([^ ].*)\\s*$");
    private final Caller caller;

    public UdisksCli(Caller caller) {
        NullCheck.notNull((Object)caller, (String)"caller");
        this.caller = caller;
    }

    public UdisksCli() {
        this(UdisksCli.createDefaultCaller());
    }

    public File mount(String device) throws IOException {
        Object[] res = this.caller.call(new String[]{"mount", "-b", device});
        if (res.length != 1) {
            Log.error((String)LOG_COMPONENT, (String)("illegal number of output lines from udisksctl mount: " + Arrays.toString(res)));
            return null;
        }
        Matcher m = PAT_MOUNTED.matcher((CharSequence)res[0]);
        if (!m.find()) {
            Log.error((String)LOG_COMPONENT, (String)("unrecognized udisksctl mount output line: " + (String)res[0]));
            return null;
        }
        return new File(m.group(1));
    }

    public void unmount(String device) throws IOException {
        this.caller.call(new String[]{"unmount", "-b", device});
    }

    public void poweroff(String device) throws IOException {
        this.caller.call(new String[]{"power-off", "-b", device});
    }

    public static Caller createDefaultCaller() {
        return args -> {
            StringBuilder cmd = new StringBuilder();
            cmd.append("udisksctl");
            if (args != null) {
                for (String a : args) {
                    cmd.append(" ").append(BashProcess.escape(a));
                }
            }
            BashProcess p = new BashProcess(new String(cmd));
            p.run();
            int exitCode = p.waitFor();
            if (exitCode != 0) {
                throw new IOException("nmcli returned " + String.valueOf(exitCode));
            }
            return p.getOutput();
        };
    }

    public static interface Caller {
        public String[] call(String[] var1) throws IOException;
    }
}

