/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim.mail;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.luwrain.core.Luwrain;
import org.luwrain.pim.mail.MessageContentItem;
import org.luwrain.pim.mail.persistence.model.MessageMetadata;
import org.luwrain.util.Sha1;
import org.luwrain.util.StreamUtils;

public class Message {
    public static final String DATA_DIR = "luwrain.pim.mail";
    public static final String MESSAGE_FILE_EXTENSION = ".gz";
    MessageMetadata metadata;
    byte[] rawMessage;
    List<MessageContentItem> contentItems;

    public Message(MessageMetadata metadata) {
        this.metadata = metadata;
        this.rawMessage = null;
        this.contentItems = MessageContentItem.fromJson(metadata.getContent());
    }

    void saveRawMessage(Luwrain luwrain) throws IOException {
        if (this.rawMessage == null || this.rawMessage.length == 0) {
            throw new IllegalStateException("The message doesn't contain the raw version");
        }
        new Sha1();
        String id = Sha1.getSha1((byte[])this.rawMessage);
        File messageFile = this.getRawMessageFileName(luwrain.getAppDataDir(DATA_DIR).toFile(), id);
        Files.createDirectories(messageFile.getParentFile().toPath(), new FileAttribute[0]);
        try (FileOutputStream fs = new FileOutputStream(messageFile);){
            try (GZIPOutputStream os = new GZIPOutputStream(fs);){
                try (ByteArrayInputStream is = new ByteArrayInputStream(this.rawMessage);){
                    StreamUtils.copyAllBytes((InputStream)is, (OutputStream)os);
                }
                os.flush();
            }
            fs.flush();
        }
    }

    byte[] loadRawMessage(Luwrain luwrain) throws IOException {
        if (this.rawMessage == null || this.rawMessage.length == 0) {
            throw new IllegalStateException("The message doesn't contain the raw version");
        }
        new Sha1();
        String id = Sha1.getSha1((byte[])this.rawMessage);
        try (GZIPInputStream is = new GZIPInputStream(new FileInputStream(this.getRawMessageFileName(luwrain.getAppDataDir(DATA_DIR).toFile(), id)));){
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            StreamUtils.copyAllBytes((InputStream)is, (OutputStream)bytes);
            byte[] byArray = bytes.toByteArray();
            return byArray;
        }
    }

    File getRawMessageFileName(File parent, String id) {
        if (id.length() < 4) {
            throw new IllegalArgumentException("id (" + id + ") can't be shorter than 4");
        }
        File f = new File(parent, id.substring(0, 1));
        f = new File(f, id.substring(0, 2));
        f = new File(f, id.substring(0, 3));
        f = new File(f, id.substring(0, 4));
        return new File(f, id + MESSAGE_FILE_EXTENSION);
    }

    public MessageMetadata getMetadata() {
        return this.metadata;
    }

    public byte[] getRawMessage() {
        return this.rawMessage;
    }

    public List<MessageContentItem> getContentItems() {
        return this.contentItems;
    }

    public void setMetadata(MessageMetadata metadata) {
        this.metadata = metadata;
    }

    public void setRawMessage(byte[] rawMessage) {
        this.rawMessage = rawMessage;
    }

    public void setContentItems(List<MessageContentItem> contentItems) {
        this.contentItems = contentItems;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MessageMetadata this$metadata = this.getMetadata();
        MessageMetadata other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        if (!Arrays.equals(this.getRawMessage(), other.getRawMessage())) {
            return false;
        }
        List<MessageContentItem> this$contentItems = this.getContentItems();
        List<MessageContentItem> other$contentItems = other.getContentItems();
        return !(this$contentItems == null ? other$contentItems != null : !((Object)this$contentItems).equals(other$contentItems));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Message;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MessageMetadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        result = result * 59 + Arrays.hashCode(this.getRawMessage());
        List<MessageContentItem> $contentItems = this.getContentItems();
        result = result * 59 + ($contentItems == null ? 43 : ((Object)$contentItems).hashCode());
        return result;
    }

    public String toString() {
        return "Message(metadata=" + String.valueOf(this.getMetadata()) + ", rawMessage=" + Arrays.toString(this.getRawMessage()) + ", contentItems=" + String.valueOf(this.getContentItems()) + ")";
    }

    public Message() {
    }
}

