/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim.mail;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class MessageContentItem {
    static final Type LIST_TYPE = new TypeToken<List<MessageContentItem>>(){}.getType();
    static final Gson gson = new Gson();
    private String contentType;
    private String disposition;
    private String fileName;
    private String text;
    private boolean alternative;

    public static String toJson(List<MessageContentItem> items) {
        if (items == null) {
            return "[]";
        }
        return gson.toJson(items);
    }

    public static List<MessageContentItem> fromJson(String s) {
        if (s == null || s.isEmpty()) {
            return Arrays.asList(new MessageContentItem[0]);
        }
        List r = (List)gson.fromJson(s, LIST_TYPE);
        if (r == null) {
            return Arrays.asList(new MessageContentItem[0]);
        }
        return new ArrayList<MessageContentItem>(r);
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getDisposition() {
        return this.disposition;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getText() {
        return this.text;
    }

    public boolean isAlternative() {
        return this.alternative;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setDisposition(String disposition) {
        this.disposition = disposition;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setAlternative(boolean alternative) {
        this.alternative = alternative;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageContentItem)) {
            return false;
        }
        MessageContentItem other = (MessageContentItem)o;
        if (this.isAlternative() != other.isAlternative()) {
            return false;
        }
        String this$contentType = this.getContentType();
        String other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
            return false;
        }
        String this$disposition = this.getDisposition();
        String other$disposition = other.getDisposition();
        if (this$disposition == null ? other$disposition != null : !this$disposition.equals(other$disposition)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        return !(this$text == null ? other$text != null : !this$text.equals(other$text));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAlternative() ? 79 : 97);
        String $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        String $disposition = this.getDisposition();
        result = result * 59 + ($disposition == null ? 43 : $disposition.hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        return result;
    }

    public String toString() {
        return "MessageContentItem(contentType=" + this.getContentType() + ", disposition=" + this.getDisposition() + ", fileName=" + this.getFileName() + ", text=" + this.getText() + ", alternative=" + this.isAlternative() + ")";
    }
}

