/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim.mail.obsolete;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.luwrain.core.NullCheck;
import org.luwrain.io.json.MessageContentType;
import org.luwrain.pim.PimException;
import org.luwrain.pim.mail.obsolete.AddressUtils;
import org.luwrain.pim.mail.obsolete.MailMessage;

public final class BinaryMessage {
    public static final String TRANSFER_ENCODING = "Content-Transfer-Encoding";
    public static final String DEFAULT_CHARSET = "UTF-8";

    public static byte[] toByteArray(MailMessage message, Map<String, String> extraHeaders) throws PimException, IOException {
        NullCheck.notNull((Object)message, (String)"message");
        NullCheck.notNull(extraHeaders, (String)"extraHeaders");
        try {
            return BinaryMessage.mimeToByteArray(BinaryMessage.convertToMimeMessage(message, extraHeaders));
        }
        catch (MessagingException e) {
            throw new PimException(e);
        }
    }

    public static MailMessage fromByteArray(byte[] bytes) throws IOException {
        NullCheck.notNull((Object)bytes, (String)"bytes");
        MailMessage message = new MailMessage();
        try {
            BinaryMessage.convertFromMimeMessage(BinaryMessage.mimeFromByteArray(bytes), message);
        }
        catch (MessagingException e) {
            throw new PimException(e);
        }
        message.setRawMessage(bytes);
        return message;
    }

    static MimeMessage convertToMimeMessage(MailMessage srcMsg, Map<String, String> headers) throws IOException, MessagingException {
        NullCheck.notNull((Object)srcMsg, (String)"srcMsg");
        NullCheck.notNull(headers, (String)"headers");
        Session session = Session.getDefaultInstance((Properties)new Properties(), null);
        MimeMessage message = new MimeMessage(session);
        for (Map.Entry<String, String> e : headers.entrySet()) {
            message.addHeader(e.getKey(), e.getValue());
        }
        if (srcMsg.getSubject() != null) {
            message.setSubject(srcMsg.getSubject());
        }
        message.setFrom((Address)BinaryMessage.encodeAddr(srcMsg.getFrom()));
        message.setRecipients(Message.RecipientType.TO, (Address[])BinaryMessage.encodeAddrs(srcMsg.getTo()));
        if (srcMsg.getCc() != null && srcMsg.getCc().length > 0) {
            message.setRecipients(Message.RecipientType.CC, (Address[])BinaryMessage.encodeAddrs(srcMsg.getCc()));
        }
        if (srcMsg.getBcc() != null && srcMsg.getBcc().length > 0) {
            message.setRecipients(Message.RecipientType.BCC, (Address[])BinaryMessage.encodeAddrs(srcMsg.getBcc()));
        }
        if (srcMsg.getSentDate() != null) {
            message.setSentDate(srcMsg.getSentDate());
        }
        if (srcMsg.getAttachments() == null || srcMsg.getAttachments().length == 0) {
            message.setText(srcMsg.getText());
            message.saveChanges();
            MessageContentType ct = srcMsg.getContentType() != null && !srcMsg.getContentType().isEmpty() ? MessageContentType.fromString(srcMsg.getContentType()) : new MessageContentType();
            if (ct.getEncoding() != null && !ct.getEncoding().isEmpty()) {
                message.setHeader(TRANSFER_ENCODING, ct.getEncoding());
            }
            return message;
        }
        MimeMultipart mp = new MimeMultipart();
        MimeBodyPart body = new MimeBodyPart();
        body.setText(srcMsg.getText());
        mp.addBodyPart((BodyPart)body);
        for (String attachment : srcMsg.getAttachments()) {
            MimeBodyPart part = new MimeBodyPart();
            File f = new File(attachment);
            part.setFileName(MimeUtility.encodeText((String)f.getName()));
            FileDataSource fds = new FileDataSource(attachment);
            part.setDataHandler(new DataHandler((DataSource)fds));
            mp.addBodyPart((BodyPart)part);
        }
        message.setContent((Multipart)mp);
        return message;
    }

    private static void convertFromMimeMessage(MimeMessage srcMsg, MailMessage dest) throws PimException, MessagingException, UnsupportedEncodingException, IOException {
        NullCheck.notNull((Object)srcMsg, (String)"srcMsg");
        NullCheck.notNull((Object)dest, (String)"dest");
        if (srcMsg.getSubject() != null) {
            dest.setSubject(srcMsg.getSubject());
        }
        if (srcMsg.getFrom() != null) {
            dest.setFrom(MimeUtility.decodeText((String)srcMsg.getFrom()[0].toString()));
        }
        if (srcMsg.getRecipients(Message.RecipientType.TO) != null) {
            dest.setTo(BinaryMessage.decodeAddrs(srcMsg.getRecipients(Message.RecipientType.TO)));
        }
        if (srcMsg.getRecipients(Message.RecipientType.CC) != null) {
            dest.setCc(BinaryMessage.decodeAddrs(srcMsg.getRecipients(Message.RecipientType.CC)));
        }
        if (srcMsg.getRecipients(Message.RecipientType.BCC) != null) {
            dest.setBcc(BinaryMessage.decodeAddrs(srcMsg.getRecipients(Message.RecipientType.BCC)));
        }
        dest.setSentDate(srcMsg.getSentDate());
        dest.setReceivedDate(srcMsg.getReceivedDate());
        MimePartCollector collector = new MimePartCollector();
        dest.setText(collector.run(srcMsg.getContent(), srcMsg.getContentType(), "", ""));
        dest.setAttachments(collector.attachments.toArray(new String[collector.attachments.size()]));
        dest.setContentType(srcMsg.getContentType());
    }

    static byte[] mimeToByteArray(MimeMessage message) throws MessagingException, IOException {
        NullCheck.notNull((Object)message, (String)"message");
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream();){
            message.writeTo((OutputStream)byteStream);
            byteStream.flush();
            byte[] byArray = byteStream.toByteArray();
            return byArray;
        }
    }

    private static MimeMessage mimeFromByteArray(byte[] bytes) throws MessagingException, IOException {
        NullCheck.notNull((Object)bytes, (String)"bytes");
        try (ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);){
            Session session = Session.getDefaultInstance((Properties)new Properties(), null);
            MimeMessage mimeMessage = new MimeMessage(session, (InputStream)byteStream);
            return mimeMessage;
        }
    }

    public static String decodeText(String text) throws IOException {
        NullCheck.notNull((Object)text, (String)"text");
        return MimeUtility.decodeText((String)text);
    }

    private static String[] decodeAddrs(Address[] addrs) throws IOException {
        if (addrs == null) {
            return new String[0];
        }
        ArrayList<String> res = new ArrayList<String>();
        for (int i = 0; i < addrs.length; ++i) {
            if (addrs[i] == null) continue;
            res.add(BinaryMessage.decodeText(addrs[i].toString()));
        }
        return res.toArray(new String[res.size()]);
    }

    static InternetAddress encodeAddr(String addr) throws IOException, AddressException {
        NullCheck.notNull((Object)addr, (String)"addr");
        String personal = AddressUtils.getPersonal(addr);
        String mail = AddressUtils.getAddress(addr);
        if (personal.trim().isEmpty()) {
            return new InternetAddress(addr);
        }
        return new InternetAddress(AddressUtils.combinePersonalAndAddr(MimeUtility.encodeText((String)personal), mail));
    }

    static InternetAddress[] encodeAddrs(String[] addrs) throws AddressException {
        NullCheck.notNullItems((Object[])addrs, (String)"addrs");
        ArrayList<InternetAddress> res = new ArrayList<InternetAddress>();
        for (String s : addrs) {
            if (s.trim().isEmpty()) continue;
            res.add(new InternetAddress(s));
        }
        return res.toArray(new InternetAddress[res.size()]);
    }

    static class MimePartCollector {
        final List<String> attachments = new ArrayList<String>();

        MimePartCollector() {
        }

        String run(Object o, String contentType, String fileName, String disposition) throws PimException, IOException, MessagingException {
            if (o instanceof MimeMultipart) {
                Multipart content = (Multipart)o;
                boolean alternative = contentType.toLowerCase().indexOf("alternative") >= 0;
                StringBuilder textRes = new StringBuilder();
                StringBuilder htmlRes = new StringBuilder();
                for (int i = 0; i < content.getCount(); ++i) {
                    boolean html;
                    MimeBodyPart part = (MimeBodyPart)content.getBodyPart(i);
                    if (part == null || part.getContent() == null) continue;
                    String partContentType = part.getContentType() != null ? part.getContentType() : "";
                    boolean bl = html = partContentType.toLowerCase().indexOf("html") >= 0;
                    if (html) {
                        htmlRes.append(this.run(part.getContent(), partContentType, part.getFileName() != null ? part.getFileName() : "", part.getDisposition() != null ? part.getDisposition() : ""));
                        continue;
                    }
                    textRes.append(this.run(part.getContent(), partContentType, part.getFileName() != null ? part.getFileName() : "", part.getDisposition() != null ? part.getDisposition() : ""));
                }
                String textStr = textRes.toString();
                String htmlStr = htmlRes.toString();
                if (!alternative) {
                    return textStr + "\n" + htmlStr;
                }
                if (!textStr.trim().isEmpty()) {
                    return textStr;
                }
                return htmlStr;
            }
            if (disposition != null && disposition.toLowerCase().indexOf("attachment") >= 0 || contentType.toLowerCase().indexOf("text") < 0) {
                if (fileName != null && !fileName.trim().isEmpty()) {
                    this.attachments.add(MimeUtility.decodeText((String)fileName));
                    this.onAttachment(MimeUtility.decodeText((String)fileName), o);
                } else {
                    this.attachments.add(contentType);
                    this.onAttachment(contentType, o);
                }
                return "";
            }
            if (contentType != null && contentType.toLowerCase().indexOf("html") >= 0) {
                return o.toString();
            }
            return o.toString();
        }

        protected void onAttachment(String fileName, Object obj) throws IOException {
        }
    }
}

