/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim.mail.script;

import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyExecutable;
import org.luwrain.core.NullCheck;
import org.luwrain.pim.PimException;
import org.luwrain.pim.mail.persistence.dao.AccountDAO;
import org.luwrain.pim.mail.persistence.model.Account;
import org.luwrain.pim.mail.script.AccountObj;
import org.luwrain.pim.mail.script.MailObj;

final class AccountsObj {
    private final AccountDAO dao;
    @HostAccess.Export
    public final ProxyExecutable newAccount = this::newAccountImpl;

    AccountsObj(AccountDAO dao) {
        NullCheck.notNull((Object)dao, (String)"dao");
        this.dao = dao;
    }

    public Object newAccountImpl(Value[] args) {
        try {
            Account a = new Account();
            this.dao.add(a);
            return new AccountObj(a);
        }
        catch (PimException ex) {
            MailObj.log.error("Unable to save newly created mail account", (Throwable)ex);
            return null;
        }
    }
}

