/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim.mail.script;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyArray;
import org.graalvm.polyglot.proxy.ProxyExecutable;
import org.luwrain.core.NullCheck;
import org.luwrain.pim.PimException;
import org.luwrain.pim.mail.Message;
import org.luwrain.pim.mail.script.AddressObj;
import org.luwrain.pim.mail.script.MailObj;
import org.luwrain.script.ScriptUtils;

public final class MessageObj {
    private static final Logger log = LogManager.getLogger();
    private final MailObj mailObj;
    public final Message message;
    private MimeMessage mimeMessage = null;
    private List<String> headers = null;
    @HostAccess.Export
    public final ProxyExecutable getSubject = this::getSubjectImpl;
    @HostAccess.Export
    public final ProxyExecutable getTitle = this::getTitleImpl;
    @HostAccess.Export
    public final ProxyExecutable setTitle = this::setTitleImpl;
    @HostAccess.Export
    public final ProxyExecutable getFrom = this::getFromImpl;
    @HostAccess.Export
    public final ProxyExecutable getTo = this::getToImpl;
    @HostAccess.Export
    public final ProxyExecutable getText = this::getTextImpl;
    @HostAccess.Export
    public ProxyExecutable getHeaders = this::getHeadersImpl;
    @HostAccess.Export
    public ProxyExecutable getHeader = this::getHeaderImpl;
    @HostAccess.Export
    public ProxyExecutable getHeaderupdate = this::updateImpl;

    public MessageObj(MailObj mailObj, Message message) {
        NullCheck.notNull((Object)mailObj, (String)"mailObj");
        NullCheck.notNull((Object)message, (String)"message");
        NullCheck.notNull((Object)message.getMetadata(), (String)"message.metadata");
        this.mailObj = mailObj;
        this.message = message;
    }

    private Object getSubjectImpl(Value[] args) {
        return this.message.getMetadata().getSubject();
    }

    private Object getTitleImpl(Value[] args) {
        return this.message.getMetadata().getTitle();
    }

    private Object setTitleImpl(Value[] args) {
        if (!ScriptUtils.notNullAndLen((Value[])args, (int)1) || !args[0].isString()) {
            throw new IllegalArgumentException("Message.setTitle() takes exactly one string argument");
        }
        this.message.getMetadata().setTitle(args[0].asString());
        return this;
    }

    private Object getFromImpl(Value[] args) {
        return new AddressObj(this.message.getMetadata().getFromAddr());
    }

    private Object getToImpl(Value[] args) {
        if (this.message.getMetadata().getToAddr() == null || this.message.getMetadata().getToAddr().isEmpty()) {
            return null;
        }
        return new AddressObj(this.message.getMetadata().getToAddr().get(0));
    }

    private Object getTextImpl(Value[] args) {
        return this.message.getMetadata().getContent();
    }

    @HostAccess.Export
    public Object getCc(Value[] args) {
        ArrayList<AddressObj> res = new ArrayList<AddressObj>();
        for (String s : this.message.getMetadata().getCcAddr()) {
            if (s == null) continue;
            res.add(new AddressObj(s));
        }
        return ProxyArray.fromArray((Object[])res.toArray(new Object[res.size()]));
    }

    private Object getHeadersImpl(Value[] args) {
        this.initMimeMessage();
        return ProxyArray.fromArray((Object[])this.headers.toArray(new String[this.headers.size()]));
    }

    private Object getHeaderImpl(Value[] args) {
        if (!ScriptUtils.notNullAndLen((Value[])args, (int)1) || !args[0].isString() || args[0].asString().trim().isEmpty()) {
            throw new IllegalArgumentException("Message.getHeader() takes exactly one non-empty string argument");
        }
        this.initMimeMessage();
        String prefix = args[0].asString().trim() + ":";
        ArrayList<String> res = new ArrayList<String>();
        for (String s : this.headers) {
            if (!s.startsWith(prefix)) continue;
            res.add(s.substring(prefix.length()).trim());
        }
        return ProxyArray.fromList(res);
    }

    private Object updateImpl(Value[] args) {
        this.mailObj.messageDAO.update(this.message.getMetadata());
        return this;
    }

    private void initMimeMessage() {
        if (this.mimeMessage != null && this.headers != null) {
            return;
        }
        if (this.message.getRawMessage() == null && this.message.getRawMessage().length == 0) {
            throw new IllegalStateException("No raw message, unable to create MIME message");
        }
        try {
            try (ByteArrayInputStream byteStream = new ByteArrayInputStream(this.message.getRawMessage());){
                this.mimeMessage = new MimeMessage(MailObj.session, (InputStream)byteStream);
            }
            this.headers = new ArrayList<String>();
            for (String h : Collections.list(this.mimeMessage.getAllHeaderLines())) {
                this.headers.add(h);
            }
        }
        catch (IOException | MessagingException ex) {
            log.catching(ex);
            this.mimeMessage = null;
            this.headers = null;
            throw new PimException(ex);
        }
    }
}

