/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim.news.nitrite;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Registry;
import org.luwrain.pim.PimException;
import org.luwrain.pim.news.NewsGroup;
import org.luwrain.pim.news.NewsGroups;
import org.luwrain.pim.news.Settings;
import org.luwrain.pim.news.nitrite.Group;

final class Groups
implements NewsGroups {
    private static final Type LIST_TYPE = new TypeToken<List<Group>>(){}.getType();
    private final Gson gson = new Gson();
    private final Settings sett;
    private List<Group> groups = null;

    Groups(Registry registry) {
        this.sett = Settings.create(registry);
    }

    public synchronized Group[] load() {
        if (this.groups != null) {
            return this.groups.toArray(new Group[this.groups.size()]);
        }
        List res = (List)this.gson.fromJson(this.sett.getGroups(""), LIST_TYPE);
        this.groups = new ArrayList<Group>();
        if (res != null) {
            for (Group g : res) {
                if (g == null) continue;
                g.groups = this;
                this.groups.add(g);
            }
        }
        return this.groups.toArray(new Group[this.groups.size()]);
    }

    synchronized void save() {
        if (this.groups != null) {
            this.sett.setGroups(this.gson.toJson(this.groups));
        }
    }

    @Override
    public synchronized NewsGroup loadById(int id) {
        for (Group g : this.load()) {
            if (g.id != id) continue;
            return g;
        }
        return null;
    }

    @Override
    public synchronized void save(NewsGroup group) throws PimException {
        NullCheck.notNull((Object)group, (String)"group");
        this.load();
        Group g = new Group();
        g.id = this.sett.getNextGroupId(0);
        this.sett.setNextGroupId(g.id + 1);
        g.groups = this;
        g.copyValues(group);
        this.groups.add(g);
        this.save();
    }

    @Override
    public synchronized void delete(NewsGroup group) {
        NullCheck.notNull((Object)group, (String)"group");
        Group g = (Group)group;
        this.load();
        for (int i = 0; i < this.groups.size(); ++i) {
            if (this.groups.get((int)i).id != g.id) continue;
            this.groups.remove(i);
        }
        this.save();
    }
}

