/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim.news.persistence;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.FutureTask;
import org.h2.mvstore.MVMap;
import org.luwrain.pim.news.persistence.dao.GroupDAO;
import org.luwrain.pim.news.persistence.model.Article;
import org.luwrain.pim.news.persistence.model.Group;
import org.luwrain.pim.storage.ExecQueues;

public final class NewsPersistence {
    final ExecQueues queues = null;
    private ExecQueues.Priority priority = ExecQueues.Priority.MEDIUM;
    private ExecQueues.Runner runner = null;
    private final MVMap<Integer, Group> groupsMap = null;
    private final MVMap<Integer, Article> articlesMap = null;
    private final MVMap<String, Long> keysMap = null;

    public GroupDAO getGroupDAO() {
        return new GroupDAO(){

            @Override
            public int add(Group group) {
                Objects.requireNonNull(group, "group can't be null");
                return NewsPersistence.this.runner.run(new FutureTask<Integer>(() -> {
                    int newId = NewsPersistence.this.getNewKey(Group.class).intValue();
                    group.setId(newId);
                    NewsPersistence.this.groupsMap.put((Object)newId, (Object)group);
                    return newId;
                }));
            }

            @Override
            public List<Group> getAll() {
                return NewsPersistence.this.runner.run(new FutureTask<List>(() -> NewsPersistence.this.groupsMap.entrySet().stream().map(e -> (Group)e.getValue()).toList()));
            }

            @Override
            public void update(Group group) {
                Objects.requireNonNull(group, "group can't be null");
                if (group.getId() < 0) {
                    throw new IllegalArgumentException("A group can't have negative ID");
                }
                NewsPersistence.this.runner.run(new FutureTask<Object>(() -> NewsPersistence.this.groupsMap.put((Object)group.getId(), (Object)group), null));
            }
        };
    }

    Long getNewKey(Class c) {
        Long res = (Long)this.keysMap.get((Object)c.getName());
        if (res == null) {
            this.keysMap.put((Object)c.getName(), (Object)0L);
            return 0L;
        }
        Long newVal = res + 1L;
        this.keysMap.put((Object)c.getName(), (Object)newVal);
        return newVal;
    }

    public void setPriority(ExecQueues.Priority priority) {
        this.priority = Objects.requireNonNull(priority, "priority can't be null");
        this.runner = new ExecQueues.Runner(this.queues, priority);
    }
}

