/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim.storage;

import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

public final class ExecQueues
implements Runnable,
AutoCloseable {
    private final ConcurrentLinkedQueue<FutureTask> mediumPriorityQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<FutureTask> highPriorityQueue = new ConcurrentLinkedQueue();
    private final Object syncObj = new Object();
    private final Thread thread = new Thread(this);
    private volatile boolean cancelling = false;

    public ExecQueues() {
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T exec(Priority priority, FutureTask<T> task) throws Exception {
        Objects.requireNonNull(priority, "priority");
        Objects.requireNonNull(task, "task can't be null");
        Object object = this.syncObj;
        synchronized (object) {
            switch (priority) {
                case MEDIUM: {
                    this.mediumPriorityQueue.add(task);
                    break;
                }
                case HIGH: {
                    this.highPriorityQueue.add(task);
                }
            }
            this.syncObj.notifyAll();
        }
        try {
            return task.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.syncObj;
        synchronized (object) {
            this.cancelling = true;
            this.syncObj.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block5: while (true) {
            Object object = this.syncObj;
            synchronized (object) {
                try {
                    while (this.highPriorityQueue.isEmpty() && this.mediumPriorityQueue.isEmpty() && !this.cancelling) {
                        this.syncObj.wait();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            if (this.cancelling) {
                return;
            }
            while (true) {
                FutureTask task;
                if (this.highPriorityQueue.isEmpty() && this.mediumPriorityQueue.isEmpty()) continue block5;
                if (this.cancelling) {
                    return;
                }
                while (!this.highPriorityQueue.isEmpty()) {
                    task = this.highPriorityQueue.poll();
                    task.run();
                }
                if (this.mediumPriorityQueue.isEmpty()) continue;
                task = this.mediumPriorityQueue.poll();
                task.run();
            }
            break;
        }
    }

    public static enum Priority {
        HIGH,
        MEDIUM;

    }

    public static final class Runner {
        final ExecQueues queues;
        final Priority priority;

        public Runner(ExecQueues queues, Priority priority) {
            this.queues = Objects.requireNonNull(queues, "queues can't be null");
            this.priority = Objects.requireNonNull(priority, "[priority can't be null");
        }

        public <T> T run(FutureTask<T> task) {
            Objects.requireNonNull(task, "task can't be null");
            try {
                return this.queues.exec(this.priority, task);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

