/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim.workers;

import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Worker;
import org.luwrain.pim.fetching.Control;
import org.luwrain.pim.fetching.Strings;
import org.luwrain.pim.mail.protocols.Smtp;
import org.luwrain.pim.workers.DefaultControl;

public class Smtp
implements Worker {
    protected static final String LOG_COMPONENT = "pim-workers";
    public static String NAME = "luwrain.pim.fetch.smtp";
    protected final Luwrain luwrain;
    protected final Control control;

    public Smtp(Luwrain luwrain) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        this.luwrain = luwrain;
        this.control = new DefaultControl(luwrain);
    }

    public Smtp(Control control) {
        NullCheck.notNull((Object)control, (String)"control");
        this.control = control;
        this.luwrain = control.luwrain();
    }

    public void run() {
        Strings strings = (Strings)this.luwrain.i18n().getStrings("luwrain.fetching");
        if (strings == null) {
            Log.error((String)LOG_COMPONENT, (String)("unable to launch the worker '" + NAME + "' since there is no strings object with the name 'luwrain.fetching'"));
            return;
        }
        try {
            org.luwrain.pim.mail.protocols.Smtp smtpFetching = new org.luwrain.pim.mail.protocols.Smtp(this.control, strings);
            Smtp.Result res = smtpFetching.send();
            if (res.total > 0) {
                if (res.total == res.sent) {
                    this.luwrain.message("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439: " + res.sent, Luwrain.MessageType.DONE);
                } else {
                    this.luwrain.message("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439", Luwrain.MessageType.ERROR);
                }
            }
        }
        catch (InterruptedException e) {
            Log.debug((String)LOG_COMPONENT, (String)("the worker '" + NAME + "' has been interrupted"));
            return;
        }
        catch (Throwable e) {
            Log.error((String)LOG_COMPONENT, (String)("the worker " + NAME + " failed:" + e.getClass().getName() + ":" + e.getMessage()));
            e.printStackTrace();
            this.luwrain.message("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439", Luwrain.MessageType.ERROR);
            return;
        }
    }

    public String getExtObjName() {
        return NAME;
    }

    public int getFirstLaunchDelay() {
        return 0;
    }

    public int getLaunchPeriod() {
        return 0;
    }
}

