/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.lsocial;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.base.TaskCancelling;
import org.luwrain.app.lsocial.App;
import org.luwrain.app.lsocial.LayoutExt;
import org.luwrain.app.lsocial.MainLayout;
import org.luwrain.app.lsocial.PublSectLayoutExt;
import org.luwrain.app.lsocial.Strings;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.list.AbstractAppearance;
import org.luwrain.controls.list.ListModel;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.events.InputEvent;
import org.luwrain.io.api.lsocial.publication.CreateSectionQuery;
import org.luwrain.io.api.lsocial.publication.GetSectionQuery;
import org.luwrain.io.api.lsocial.publication.GetSectionResponse;
import org.luwrain.io.api.lsocial.publication.Publication;
import org.luwrain.io.api.lsocial.publication.Section;

class PublLayoutExt
implements LayoutExt {
    private static final Logger log = LogManager.getLogger();
    final App app;
    final MainLayout mainLayout;
    final Publication publ;
    final List<Section> sections = new ArrayList<Section>();
    final ListArea<Section> sectList;
    final LayoutBase.Actions actions;

    PublLayoutExt(MainLayout mainLayout, Publication publ) {
        this.app = mainLayout.app;
        this.mainLayout = mainLayout;
        this.publ = publ;
        Strings s = (Strings)mainLayout.app.getStrings();
        if (publ.getSects() != null) {
            this.sections.addAll(publ.getSects());
        }
        this.sectList = new ListArea(mainLayout.listParams(p -> {
            p.name = s.appName();
            p.model = new ListModel(this.sections);
            p.appearance = new Appearance();
            p.clickHandler = (area, index, sect) -> this.onSectClick((Section)sect);
        }));
        this.actions = mainLayout.actions(new LayoutBase.ActionInfo[]{mainLayout.action("insert", s.create(), new InputEvent(InputEvent.Special.INSERT), this::onInsert)});
    }

    boolean onInsert() {
        int type = this.app.conv.newPublSectType();
        if (type < 0) {
            return true;
        }
        TaskCancelling.TaskId taskId = this.app.newTaskId();
        return this.app.runTask(taskId, () -> ((CreateSectionQuery)new CreateSectionQuery("https://luwrain.social").accessToken(this.app.conf.getAccessToken())).publ(String.valueOf(this.publ.getId())).type(type).source("").exec());
    }

    boolean onSectClick(Section sect) {
        int index = this.sectList.selectedIndex();
        if (index < 0) {
            return false;
        }
        TaskCancelling.TaskId taskId = this.app.newTaskId();
        return this.app.runTask(taskId, () -> {
            GetSectionResponse res = (GetSectionResponse)((GetSectionQuery)new GetSectionQuery("https://luwrain.social").accessToken(this.app.conf.getAccessToken())).publ(this.publ).sect(index).exec();
            this.app.finishedTask(taskId, () -> {
                PublSectLayoutExt e = new PublSectLayoutExt(this, this.publ, res.getSect(), index);
                this.mainLayout.openExt(e);
            });
        });
    }

    @Override
    public void setLayout() {
        this.mainLayout.setAreaLayout(AreaLayout.LEFT_RIGHT, (Area)this.mainLayout.mainList, this.mainLayout.mainListActions, (Area)this.sectList, this.actions);
    }

    @Override
    public void activateDefaultArea() {
        this.mainLayout.setActiveArea((Area)this.sectList);
    }

    final class Appearance
    extends AbstractAppearance<Section> {
        Appearance() {
        }

        public void announceItem(Section sect, Set<ListArea.Appearance.Flags> flags) {
            switch (sect.getType()) {
                case 0: 
                case 1: {
                    PublLayoutExt.this.app.getLuwrain().setEventResponse(DefaultEventResponse.listItem((String)sect.getSrc().stream().collect(Collectors.joining(" "))));
                    return;
                }
                case 4: {
                    PublLayoutExt.this.app.getLuwrain().setEventResponse(DefaultEventResponse.listItem((String)(((Strings)PublLayoutExt.this.app.getStrings()).typeMetapost() + " " + this.captOrSource(sect))));
                    return;
                }
                case 5: {
                    PublLayoutExt.this.app.getLuwrain().setEventResponse(DefaultEventResponse.listItem((String)(((Strings)PublLayoutExt.this.app.getStrings()).typeGnuplot() + " " + this.captOrSource(sect))));
                    return;
                }
                case 7: {
                    PublLayoutExt.this.app.getLuwrain().setEventResponse(DefaultEventResponse.listItem((String)(((Strings)PublLayoutExt.this.app.getStrings()).typeListing() + " " + this.captOrSource(sect))));
                    return;
                }
            }
            PublLayoutExt.this.app.getLuwrain().setEventResponse(DefaultEventResponse.listItem((String)this.captOrSource(sect)));
        }

        public String getScreenAppearance(Section sect, Set<ListArea.Appearance.Flags> flags) {
            switch (sect.getType()) {
                case 0: 
                case 1: {
                    if (sect.getSrc().isEmpty()) {
                        return "";
                    }
                    if (sect.getSrc().size() == 1) {
                        return (String)sect.getSrc().get(0);
                    }
                    return (String)sect.getSrc().get(0) + "...";
                }
            }
            return this.captOrSource(sect);
        }

        String captOrSource(Section sect) {
            String capt = sect.getCapt() != null ? sect.getCapt().stream().collect(Collectors.joining("\n")).trim() : "";
            if (!capt.isEmpty()) {
                return capt;
            }
            if (!sect.getSrc().isEmpty()) {
                return (String)sect.getSrc().get(0);
            }
            return "";
        }
    }
}

