/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.lsocial;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.base.TaskCancelling;
import org.luwrain.app.lsocial.App;
import org.luwrain.app.lsocial.LayoutExt;
import org.luwrain.app.lsocial.MainLayout;
import org.luwrain.app.lsocial.PublLayoutExt;
import org.luwrain.controls.edit.EditArea;
import org.luwrain.controls.edit.MultilineEdit;
import org.luwrain.controls.edit.MultilineEditModelWrap;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.Sounds;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.io.api.lsocial.publication.Publication;
import org.luwrain.io.api.lsocial.publication.Section;
import org.luwrain.io.api.lsocial.publication.UpdateSectionQuery;

class PublSectLayoutExt
implements LayoutExt {
    private static final Logger log = LogManager.getLogger();
    final App app;
    final MainLayout mainLayout;
    final PublLayoutExt publLayout;
    final Publication publ;
    final Section sect;
    final int sectIndex;
    final EditArea edit;
    final LayoutBase.Actions actions;

    PublSectLayoutExt(PublLayoutExt publLayout, Publication publ, Section sect, int sectIndex) {
        this.publLayout = publLayout;
        this.mainLayout = publLayout.mainLayout;
        this.app = this.mainLayout.app;
        this.publ = publ;
        this.sect = sect;
        this.sectIndex = sectIndex;
        this.edit = new EditArea(this.mainLayout.editParams(p -> {
            p.editFactory = e -> {
                e.model = new MultilineEditModelWrap(e.model){

                    public MultilineEdit.ModificationResult putChars(int x, int y, String chars) {
                        return super.putChars(x, y, PublSectLayoutExt.this.app.translateUserInput(this.getLine(this.getHotPointY()), x, chars));
                    }
                };
                return new MultilineEdit(e);
            };
        })){

            public boolean onSystemEvent(SystemEvent event) {
                if (event.getType() != SystemEvent.Type.REGULAR) {
                    return super.onSystemEvent(event);
                }
                switch (event.getCode()) {
                    case SAVE: {
                        return PublSectLayoutExt.this.onSave();
                    }
                }
                return super.onSystemEvent(event);
            }
        };
        List text = Objects.requireNonNullElse(sect.getSrc(), new ArrayList());
        this.edit.setText(text.toArray(new String[text.size()]));
        this.actions = this.mainLayout.actions(new LayoutBase.ActionInfo[0]);
    }

    boolean onSave() {
        TaskCancelling.TaskId taskId = this.app.newTaskId();
        return this.app.runTask(taskId, () -> {
            ((UpdateSectionQuery)new UpdateSectionQuery("https://luwrain.social").accessToken(this.app.conf.getAccessToken())).publ(String.valueOf(this.publ.getId())).sect(String.valueOf(this.sectIndex)).source(this.edit.getTextAsList().stream().collect(Collectors.joining("\n"))).exec();
            this.app.finishedTask(taskId, () -> this.app.getLuwrain().playSound(Sounds.DONE));
        });
    }

    @Override
    public void setLayout() {
        this.mainLayout.setAreaLayout(AreaLayout.LEFT_TOP_BOTTOM, (Area)this.mainLayout.mainList, this.mainLayout.mainListActions, (Area)this.publLayout.sectList, this.publLayout.actions, (Area)this.edit, this.actions);
    }

    @Override
    public void activateDefaultArea() {
        this.mainLayout.setActiveArea((Area)this.edit);
    }
}

