/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.lsocial.layouts;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.base.TaskCancelling;
import org.luwrain.app.lsocial.App;
import org.luwrain.app.lsocial.MainLayout;
import org.luwrain.app.lsocial.Strings;
import org.luwrain.controls.WizardArea;
import org.luwrain.core.Area;
import org.luwrain.core.Luwrain;
import org.luwrain.io.api.lsocial.publication.CreateQuery;
import org.luwrain.io.api.lsocial.publication.CreateResponse;

public final class NewEntryLayout
extends LayoutBase {
    static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd MMMM YYYY \u0433");
    final App app;
    final MainLayout mainLayout;
    final WizardArea wizard;
    final LayoutBase.ActionHandler close;

    public NewEntryLayout(App app, MainLayout mainLayout, LayoutBase.ActionHandler close) {
        super((AppBase)app);
        this.app = app;
        this.mainLayout = mainLayout;
        this.close = close;
        Strings s = (Strings)app.getStrings();
        this.wizard = new WizardArea(this.getControlContext());
        this.wizard.setAreaName(s.newEntryAreaName());
        WizardArea.Frame fr = this.wizard.newFrame().addInput(s.nameEdit(), "").addInput(s.subjectEdit(), "").addInput(s.titleEdit(), "").addInput(s.authorsEdit(), "").addInput(s.dateEdit(), DATE_FORMAT.format(new Date())).addClickable(s.presentationClickable(), v -> this.create(Type.PR, v)).addClickable(s.paperClickable(), v -> this.create(Type.PAPER, v)).addClickable(s.bookClickable(), v -> this.create(Type.BOOK, v)).addClickable(s.thesisClickable(), v -> this.create(Type.THESIS, v)).addClickable(s.graduationWorkClickable(), v -> this.create(Type.GRADUATION, v)).addClickable(s.courseWorkClickable(), v -> this.create(Type.COURSE, v));
        this.wizard.show(fr);
        this.setCloseHandler(close);
        this.setAreaLayout((Area)this.wizard, null);
    }

    boolean create(Type type, WizardArea.WizardValues values) {
        int t;
        String name = values.getText(0).trim();
        String subject = values.getText(1).trim();
        String title = values.getText(2).trim();
        String authors = values.getText(3).trim();
        String date = values.getText(4);
        if (name.isEmpty()) {
            this.app.message(((Strings)this.app.getStrings()).nameCannotBeEmpty(), Luwrain.MessageType.ERROR);
            return true;
        }
        if (type == Type.PR) {
            TaskCancelling.TaskId taskId = this.app.newTaskId();
            return this.app.runTask(taskId, () -> {
                org.luwrain.io.api.lsocial.presentation.CreateResponse resp = (org.luwrain.io.api.lsocial.presentation.CreateResponse)((org.luwrain.io.api.lsocial.presentation.CreateQuery)new org.luwrain.io.api.lsocial.presentation.CreateQuery("https://luwrain.social").accessToken(this.app.conf.getAccessToken())).name(name).title(title).authors(authors).subject(subject).date(date).exec();
                List<Object> res = this.mainLayout.fetchMainListItems();
                this.app.finishedTask(taskId, () -> {
                    this.mainLayout.entries.clear();
                    this.mainLayout.entries.addAll(res);
                    this.mainLayout.mainList.refresh();
                    this.close.onAction();
                });
            });
        }
        switch (type) {
            case PAPER: {
                t = 0;
                break;
            }
            case BOOK: {
                t = 1;
                break;
            }
            case THESIS: {
                t = 2;
                break;
            }
            case GRADUATION: {
                t = 3;
                break;
            }
            case COURSE: {
                t = 4;
                break;
            }
            default: {
                return false;
            }
        }
        TaskCancelling.TaskId taskId = this.app.newTaskId();
        return this.app.runTask(taskId, () -> {
            CreateResponse resp = (CreateResponse)((CreateQuery)new CreateQuery("https://luwrain.social").accessToken(this.app.conf.getAccessToken())).type(t).name(name).title(title).authors(authors).subject(subject).date(date).exec();
            List<Object> res = this.mainLayout.fetchMainListItems();
            this.app.finishedTask(taskId, () -> {
                this.mainLayout.entries.clear();
                this.mainLayout.entries.addAll(res);
                this.mainLayout.mainList.refresh();
                this.close.onAction();
            });
        });
    }

    static enum Type {
        PR,
        PAPER,
        BOOK,
        THESIS,
        GRADUATION,
        COURSE;

    }
}

