/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.lsocial.layouts;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Predicate;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.lsocial.App;
import org.luwrain.app.lsocial.Strings;
import org.luwrain.controls.FormArea;
import org.luwrain.core.Area;
import org.luwrain.io.api.lsocial.presentation.Presentation;

public final class NewPresentationLayout
extends LayoutBase {
    private static final String NAME = "name";
    private static final String TITLE = "title";
    private static final String AUTHORS = "authors";
    private static final String SUBJECT = "subject";
    private static final String DATE = "date";
    static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd MMMM YYYY \u0433");
    final App app;
    final FormArea form;

    public NewPresentationLayout(App app, LayoutBase.ActionHandler close, Predicate<Presentation> okFunc) {
        super((AppBase)app);
        this.app = app;
        Strings s = (Strings)app.getStrings();
        this.form = new FormArea(this.getControlContext(), s.newPresentationAreaName());
        this.form.addEdit(NAME, s.nameEdit(), "");
        this.form.addEdit(TITLE, s.titleEdit(), "");
        this.form.addEdit(AUTHORS, s.authorsEdit(), "");
        this.form.addEdit(SUBJECT, s.subjectEdit(), "");
        this.form.addEdit(DATE, s.dateEdit(), DATE_FORMAT.format(new Date()));
        this.setAreaLayout((Area)this.form, null);
        this.setOkHandler(() -> {
            Presentation p = new Presentation();
            p.setName(this.form.getEnteredText(NAME));
            p.setTitle(this.form.getEnteredText(TITLE));
            p.setAuthors(this.form.getEnteredText(AUTHORS));
            p.setSubject(this.form.getEnteredText(SUBJECT));
            p.setDate(this.form.getEnteredText(DATE));
            if (okFunc.test(p)) {
                close.onAction();
            }
            return true;
        });
        this.setCloseHandler(close);
    }
}

