/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.i18n.en;

import com.google.auto.service.AutoService;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.app.cpanel.Strings;
import org.luwrain.core.Luwrain;
import org.luwrain.i18n.I18nExtension;
import org.luwrain.i18n.I18nExtensionBase;
import org.luwrain.i18n.Lang;
import org.luwrain.i18n.ResourceStringsObj;

@AutoService(value={org.luwrain.core.Extension.class})
public class Extension
extends I18nExtensionBase {
    private static final Logger log = LogManager.getLogger();
    private static final String LANG_NAME = "en";
    private static final String RESOURCE_PATH = "org/luwrain/i18n/en/constants.properties";

    public Extension() {
        super(LANG_NAME);
    }

    public void i18nExtension(Luwrain luwrain, I18nExtension ext) {
        try {
            this.init(((Object)((Object)this)).getClass().getClassLoader(), luwrain);
            ext.addLang(LANG_NAME, (Lang)new org.luwrain.i18n.en.Lang(luwrain, this.readStaticStrings(), this.readChars()));
            this.loadCommands(ext);
            this.loadStrings(org.luwrain.app.console.Strings.class, "console.txt", ext);
            this.loadStrings(org.luwrain.app.crash.Strings.class, "crash.txt", ext);
            this.loadStrings(Strings.class, "cpanel.txt", ext);
        }
        catch (IOException e) {
            log.error("Unable to init the language", (Throwable)e);
        }
    }

    private void loadStrings(Class c, String resName, I18nExtension ext) throws IOException {
        ext.addStrings(LANG_NAME, c.getName(), new ResourceStringsObj(Extension.class.getClassLoader(), Extension.class, resName).create("ru", c));
    }
}

