/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.io;

import java.util.ArrayList;
import org.luwrain.core.NullCheck;
import org.luwrain.script.ScriptUtils;

public final class WebSearchResult {
    private final String title;
    private final Item[] items;

    public WebSearchResult(String title, Item[] items) {
        NullCheck.notNull((Object)title, (String)"title");
        NullCheck.notNullItems((Object[])items, (String)"items");
        this.title = title;
        this.items = items;
    }

    public String getTitle() {
        return this.title;
    }

    public Item[] getItems() {
        return (Item[])this.items.clone();
    }

    public Item getItem(int index) {
        return this.items[index];
    }

    public int getItemCount() {
        return this.items.length;
    }

    public boolean noItems() {
        return this.items.length == 0;
    }

    public static Item[] getItemsFromHookObj(Object itemsObj) {
        if (itemsObj == null) {
            return null;
        }
        Object[] items = ScriptUtils.asArray((Object)itemsObj);
        if (items == null) {
            return null;
        }
        ArrayList<Item> res = new ArrayList<Item>();
        for (Object o : items) {
            if (o == null) continue;
            String title = ScriptUtils.asString((Object)ScriptUtils.getMember((Object)o, (String)"title"));
            String snippet = ScriptUtils.asString((Object)ScriptUtils.getMember((Object)o, (String)"snippet"));
            String displayUrl = ScriptUtils.asString((Object)ScriptUtils.getMember((Object)o, (String)"displayUrl"));
            String clickUrl = ScriptUtils.asString((Object)ScriptUtils.getMember((Object)o, (String)"clickUrl"));
            if (title == null || title.trim().isEmpty()) continue;
            res.add(new Item(title.trim(), snippet != null ? snippet.trim() : "", displayUrl != null ? displayUrl.trim() : "", clickUrl != null ? clickUrl.trim() : ""));
        }
        return res.toArray(new Item[res.size()]);
    }

    public static final class Item {
        private final String title;
        private final String snippet;
        private final String displayUrl;
        private final String clickUrl;

        public Item(String title, String snippet, String displayUrl, String clickUrl) {
            NullCheck.notNull((Object)title, (String)"title");
            NullCheck.notNull((Object)snippet, (String)"snippet");
            NullCheck.notNull((Object)displayUrl, (String)"displayUrl");
            NullCheck.notNull((Object)clickUrl, (String)"clickUrl");
            this.title = title;
            this.snippet = snippet;
            this.displayUrl = displayUrl;
            this.clickUrl = clickUrl;
        }

        public String getTitle() {
            return this.title;
        }

        public String getSnippet() {
            return this.snippet;
        }

        public String getDisplayUrl() {
            return this.displayUrl;
        }

        public String getClickUrl() {
            return this.clickUrl;
        }

        public String toString() {
            return this.title;
        }
    }
}

