/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.io.api.duckduckgo;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;
import org.luwrain.util.Connections;

public final class InstantAnswer {
    private static final String CHARSET = "UTF-8";
    private static Gson gson = null;

    public Answer getAnswer(String query, Properties props, Set<Flags> flags) throws IOException {
        URLConnection con;
        NullCheck.notEmpty((Object)query, (String)"query");
        NullCheck.notNull((Object)props, (String)"props");
        NullCheck.notNull(flags, (String)"flags");
        if (gson == null) {
            gson = new Gson();
        }
        StringBuilder b = new StringBuilder();
        b.append("https://api.duckduckgo.com/?q=").append(URLEncoder.encode(query, CHARSET)).append("&format=json");
        if (props.getProperty("kl") != null && !props.getProperty("kl").isEmpty()) {
            b.append("&kl=").append(props.getProperty("kl"));
        }
        URL url = new URL(new String(b));
        Log.debug((String)"proba", (String)url.toString());
        try {
            con = Connections.connect((URI)url.toURI(), (long)0L);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        try (BufferedReader r = new BufferedReader(new InputStreamReader(con.getInputStream(), CHARSET));){
            Log.debug((String)"proba", (String)"data");
            Answer answer = (Answer)gson.fromJson((Reader)r, Answer.class);
            return answer;
        }
    }

    public static final class Answer {
        public static final String TYPE_A = "A";
        public static final String TYPE_D = "D";
        @SerializedName(value="Type")
        private String type = null;
        @SerializedName(value="Heading")
        private String heading = null;
        @SerializedName(value="AbstractText")
        private String absText = null;
        @SerializedName(value="RelatedTopics")
        private List<RelatedTopic> relatedTopics;

        public String getType() {
            return this.type;
        }

        public String getAbsText() {
            return this.absText;
        }

        public String getHeading() {
            return this.heading;
        }

        public RelatedTopic[] getRelatedTopics() {
            return this.relatedTopics != null ? this.relatedTopics.toArray(new RelatedTopic[this.relatedTopics.size()]) : null;
        }
    }

    public static final class RelatedTopic {
        @SerializedName(value="Text")
        private String text = null;
        @SerializedName(value="FirstURL")
        private String firstUrl = null;

        public String getText() {
            return this.text;
        }

        public String getFirstUrl() {
            return this.firstUrl;
        }

        public String toString() {
            return this.text != null ? this.text : "";
        }
    }

    public static final class Flags
    extends Enum<Flags> {
        private static final /* synthetic */ Flags[] $VALUES;

        public static Flags[] values() {
            return (Flags[])$VALUES.clone();
        }

        public static Flags valueOf(String name) {
            return Enum.valueOf(Flags.class, name);
        }

        private static /* synthetic */ Flags[] $values() {
            return new Flags[0];
        }

        static {
            $VALUES = Flags.$values();
        }
    }
}

