/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.io.filters.html;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.luwrain.core.NullCheck;

class AttrsBase {
    static final String LOG_COMPONENT = "reader";
    private final List<org.luwrain.io.textdoc.Attributes> attrsStack = new ArrayList<org.luwrain.io.textdoc.Attributes>();

    AttrsBase() {
    }

    protected void addAttrs(Element el) {
        NullCheck.notNull((Object)el, (String)"el");
        org.luwrain.io.textdoc.Attributes attr = new org.luwrain.io.textdoc.Attributes();
        attr.tagName = el.nodeName();
        Attributes a = el.attributes();
        if (a != null) {
            for (Attribute aa : a.asList()) {
                String key = aa.getKey();
                String value = aa.getValue();
                if (key == null || key.isEmpty() || value == null) continue;
                attr.attrMap.put(key, value);
            }
        }
        if (!this.attrsStack.isEmpty()) {
            attr.parentAttr.addAll(this.attrsStack);
        }
        this.attrsStack.add(attr);
    }

    protected void releaseAttrs() {
        if (!this.attrsStack.isEmpty()) {
            this.attrsStack.remove(this.attrsStack.size() - 1);
        }
    }

    protected org.luwrain.io.textdoc.Attributes getAttributes() {
        return this.attrsStack.isEmpty() ? null : this.attrsStack.get(this.attrsStack.size() - 1);
    }

    protected static void collectMeta(Element el, Map<String, String> meta) {
        NullCheck.notNull((Object)el, (String)"el");
        NullCheck.notNull(meta, (String)"meta");
        if (el.nodeName().equals("meta")) {
            String name = el.attr("name");
            String content = el.attr("content");
            if (name != null && !name.isEmpty() && content != null) {
                meta.put(name, content);
            }
        }
        if (el.childNodes() != null) {
            for (Node n : el.childNodes()) {
                if (!(n instanceof Element)) continue;
                AttrsBase.collectMeta((Element)n, meta);
            }
        }
    }
}

